/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class DisplayNameListener
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(DisplayNameListener.class.getName());

    @Override
    public void onCopied(Item src, Item item) {
        if (item instanceof AbstractItem && src.getParent() == item.getParent()) {
            AbstractItem dest = (AbstractItem)item;
            try {
                dest.setDisplayName(null);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, String.format("onCopied():Exception while trying to clear the displayName for Item.name:%s", item.getName()), ioe);
            }
        }
    }

    @Override
    public void onRenamed(Item item, String oldName, String newName) {
        AbstractItem abstractItem;
        if (item instanceof AbstractItem && oldName.equals((abstractItem = (AbstractItem)item).getDisplayName())) {
            try {
                LOGGER.info(String.format("onRenamed():Setting displayname to null for item.name=%s", item.getName()));
                abstractItem.setDisplayName(null);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, String.format("onRenamed():Exception while trying to clear the displayName for Item.name:%s", item.getName()), ioe);
            }
        }
    }
}

