/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jsr269;

import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner9;
import javax.tools.Diagnostic;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.jsr269.AbstractProcessorImpl;

@SupportedAnnotationTypes(value={"*"})
public class ConstructorProcessor
extends AbstractProcessorImpl {
    static final String MESSAGE = "Only one annotated constructor (@DataBoundConstructor annotation or @stapler-constructor javadoc) is permitted per class";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ElementScanner9<Void, Void> scanner = new ElementScanner9<Void, Void>(){
                Set<Element> enclosingElementsWritten = new HashSet<Element>();
                boolean messagePrinted;

                @Override
                public Void visitExecutable(ExecutableElement e, Void aVoid) {
                    if (e.getAnnotation(DataBoundConstructor.class) != null) {
                        this.writeOrAddOnlyOneMessage(e);
                    } else {
                        String javadoc = ConstructorProcessor.this.getJavadoc(e);
                        if (javadoc != null && javadoc.contains("@stapler-constructor")) {
                            this.writeOrAddOnlyOneMessage(e);
                        }
                    }
                    return (Void)super.visitExecutable(e, aVoid);
                }

                @Override
                public Void visitUnknown(Element e, Void aVoid) {
                    return (Void)this.DEFAULT_VALUE;
                }

                private void writeOrAddOnlyOneMessage(ExecutableElement e) {
                    if (this.enclosingElementsWritten.add(e.getEnclosingElement())) {
                        ConstructorProcessor.this.write(e);
                    } else if (!this.messagePrinted) {
                        ConstructorProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ConstructorProcessor.MESSAGE, e);
                        this.messagePrinted = true;
                    }
                }
            };
            for (Element element : roundEnv.getRootElements()) {
                if (element.getKind() == ElementKind.PACKAGE) continue;
                scanner.scan(element, null);
            }
            return false;
        }
        catch (Error | RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void write(ExecutableElement c) {
        if (!c.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@DataBoundConstructor must be applied to a public constructor", c);
            return;
        }
        if (c.getEnclosingElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@DataBoundConstructor may not be used on an abstract class (only on concrete subclasses)", c);
            return;
        }
        try {
            StringBuilder buf = new StringBuilder();
            for (VariableElement variableElement : c.getParameters()) {
                if (!buf.isEmpty()) {
                    buf.append(',');
                }
                buf.append(variableElement.getSimpleName());
            }
            TypeElement t = (TypeElement)c.getEnclosingElement();
            String string = t.getQualifiedName().toString().replace('.', '/') + ".stapler";
            this.notice("Generating " + string, c);
            Properties p = new Properties();
            p.put("constructor", buf.toString());
            this.writePropertyFile(p, string);
        }
        catch (IOException x) {
            this.error(x);
        }
    }
}

