/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;

abstract class NameBasedDispatcher
extends Dispatcher {
    protected final String name;
    private final int argCount;

    protected NameBasedDispatcher(String name, int argCount) {
        this.name = name;
        this.argCount = argCount;
    }

    protected NameBasedDispatcher(String name) {
        this(name, 0);
    }

    @Override
    public final boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
        if (!req.tokens.hasMore() || !req.tokens.peek().equals(this.name)) {
            return false;
        }
        if (req.tokens.countRemainingTokens() <= this.argCount) {
            return false;
        }
        req.tokens.next();
        boolean b = this.doDispatch(req, rsp, node);
        if (!b) {
            req.tokens.prev();
        }
        return b;
    }

    protected abstract boolean doDispatch(RequestImpl var1, ResponseImpl var2, Object var3) throws IOException, ServletException, IllegalAccessException, InvocationTargetException;
}

