/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.servlet.http;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.servlet.ServletOutputStreamWrapper;
import io.jenkins.servlet.ServletResponseWrapper;
import io.jenkins.servlet.http.CookieWrapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class HttpServletResponseWrapper {
    public static jakarta.servlet.http.HttpServletResponse toJakartaHttpServletResponse(HttpServletResponse from) {
        if (from instanceof JavaxHttpServletResponseWrapper) {
            JavaxHttpServletResponseWrapper javax = (JavaxHttpServletResponseWrapper)from;
            return javax.toJakartaHttpServletResponse();
        }
        return new JakartaHttpServletResponseWrapperImpl(from);
    }

    public static HttpServletResponse fromJakartaHttpServletResponse(jakarta.servlet.http.HttpServletResponse from) {
        if (from instanceof JakartaHttpServletResponseWrapper) {
            JakartaHttpServletResponseWrapper jakarta = (JakartaHttpServletResponseWrapper)from;
            return jakarta.toJavaxHttpServletResponse();
        }
        return new JavaxHttpServletResponseWrapperImpl(from);
    }

    public static interface JavaxHttpServletResponseWrapper {
        public jakarta.servlet.http.HttpServletResponse toJakartaHttpServletResponse();
    }

    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT", "URL_REWRITING", "XSS_SERVLET"}, justification="for compatibility")
    private static class JakartaHttpServletResponseWrapperImpl
    implements jakarta.servlet.http.HttpServletResponse,
    ServletResponseWrapper.JakartaServletResponseWrapper,
    JakartaHttpServletResponseWrapper {
        private final HttpServletResponse from;

        JakartaHttpServletResponseWrapperImpl(HttpServletResponse from) {
            this.from = Objects.requireNonNull(from);
        }

        public String getCharacterEncoding() {
            return this.from.getCharacterEncoding();
        }

        public String getContentType() {
            return this.from.getContentType();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return ServletOutputStreamWrapper.toJakartaServletOutputStream(this.from.getOutputStream());
        }

        public PrintWriter getWriter() throws IOException {
            return this.from.getWriter();
        }

        public void setCharacterEncoding(String charset) {
            this.from.setCharacterEncoding(charset);
        }

        public void setContentLength(int len) {
            this.from.setContentLength(len);
        }

        public void setContentLengthLong(long len) {
            this.from.setContentLengthLong(len);
        }

        public void setContentType(String type) {
            this.from.setContentType(type);
        }

        public void setBufferSize(int size) {
            this.from.setBufferSize(size);
        }

        public int getBufferSize() {
            return this.from.getBufferSize();
        }

        public void flushBuffer() throws IOException {
            this.from.flushBuffer();
        }

        public void resetBuffer() {
            this.from.resetBuffer();
        }

        public boolean isCommitted() {
            return this.from.isCommitted();
        }

        public void reset() {
            this.from.reset();
        }

        public void setLocale(Locale loc) {
            this.from.setLocale(loc);
        }

        public Locale getLocale() {
            return this.from.getLocale();
        }

        public void addCookie(Cookie cookie) {
            this.from.addCookie(CookieWrapper.fromJakartaServletHttpCookie(cookie));
        }

        public boolean containsHeader(String name) {
            return this.from.containsHeader(name);
        }

        public String encodeURL(String url) {
            return this.from.encodeURL(url);
        }

        public String encodeRedirectURL(String url) {
            return this.from.encodeRedirectURL(url);
        }

        public String encodeUrl(String url) {
            return this.from.encodeUrl(url);
        }

        public String encodeRedirectUrl(String url) {
            return this.from.encodeRedirectUrl(url);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.from.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.from.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.from.sendRedirect(location);
        }

        public void setDateHeader(String name, long date) {
            this.from.setDateHeader(name, date);
        }

        public void addDateHeader(String name, long date) {
            this.from.addDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            this.from.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            this.from.addHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.from.setIntHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.from.addIntHeader(name, value);
        }

        public void setStatus(int sc) {
            this.from.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.from.setStatus(sc, sm);
        }

        public int getStatus() {
            return this.from.getStatus();
        }

        public String getHeader(String name) {
            return this.from.getHeader(name);
        }

        public Collection<String> getHeaders(String name) {
            return this.from.getHeaders(name);
        }

        public Collection<String> getHeaderNames() {
            return this.from.getHeaderNames();
        }

        public void setTrailerFields(Supplier<Map<String, String>> supplier) {
            this.from.setTrailerFields(supplier);
        }

        public Supplier<Map<String, String>> getTrailerFields() {
            return this.from.getTrailerFields();
        }

        @Override
        public ServletResponse toJavaxServletResponse() {
            return this.from;
        }

        @Override
        public HttpServletResponse toJavaxHttpServletResponse() {
            return this.from;
        }
    }

    public static interface JakartaHttpServletResponseWrapper {
        public HttpServletResponse toJavaxHttpServletResponse();
    }

    private static class JavaxHttpServletResponseWrapperImpl
    implements HttpServletResponse,
    ServletResponseWrapper.JavaxServletResponseWrapper,
    JavaxHttpServletResponseWrapper {
        private final jakarta.servlet.http.HttpServletResponse from;

        JavaxHttpServletResponseWrapperImpl(jakarta.servlet.http.HttpServletResponse from) {
            this.from = Objects.requireNonNull(from);
        }

        public String getCharacterEncoding() {
            return this.from.getCharacterEncoding();
        }

        public String getContentType() {
            return this.from.getContentType();
        }

        public javax.servlet.ServletOutputStream getOutputStream() throws IOException {
            return ServletOutputStreamWrapper.fromJakartaServletOutputStream(this.from.getOutputStream());
        }

        public PrintWriter getWriter() throws IOException {
            return this.from.getWriter();
        }

        public void setCharacterEncoding(String charset) {
            this.from.setCharacterEncoding(charset);
        }

        public void setContentLength(int len) {
            this.from.setContentLength(len);
        }

        public void setContentLengthLong(long len) {
            this.from.setContentLengthLong(len);
        }

        public void setContentType(String type) {
            this.from.setContentType(type);
        }

        public void setBufferSize(int size) {
            this.from.setBufferSize(size);
        }

        public int getBufferSize() {
            return this.from.getBufferSize();
        }

        public void flushBuffer() throws IOException {
            this.from.flushBuffer();
        }

        public void resetBuffer() {
            this.from.resetBuffer();
        }

        public boolean isCommitted() {
            return this.from.isCommitted();
        }

        public void reset() {
            this.from.reset();
        }

        public void setLocale(Locale loc) {
            this.from.setLocale(loc);
        }

        public Locale getLocale() {
            return this.from.getLocale();
        }

        public void addCookie(javax.servlet.http.Cookie cookie) {
            this.from.addCookie(CookieWrapper.toJakartaServletHttpCookie(cookie));
        }

        public boolean containsHeader(String name) {
            return this.from.containsHeader(name);
        }

        @SuppressFBWarnings(value={"URL_REWRITING"}, justification="for compatibility")
        public String encodeURL(String url) {
            return this.from.encodeURL(url);
        }

        @SuppressFBWarnings(value={"URL_REWRITING"}, justification="for compatibility")
        public String encodeRedirectURL(String url) {
            return this.from.encodeRedirectURL(url);
        }

        @SuppressFBWarnings(value={"URL_REWRITING"}, justification="for compatibility")
        public String encodeUrl(String url) {
            return this.from.encodeUrl(url);
        }

        @SuppressFBWarnings(value={"URL_REWRITING"}, justification="for compatibility")
        public String encodeRedirectUrl(String url) {
            return this.from.encodeRedirectUrl(url);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.from.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.from.sendError(sc);
        }

        @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="for compatibility")
        public void sendRedirect(String location) throws IOException {
            this.from.sendRedirect(location);
        }

        public void setDateHeader(String name, long date) {
            this.from.setDateHeader(name, date);
        }

        public void addDateHeader(String name, long date) {
            this.from.addDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            this.from.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            this.from.addHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.from.setIntHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.from.addIntHeader(name, value);
        }

        public void setStatus(int sc) {
            this.from.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.from.setStatus(sc, sm);
        }

        public int getStatus() {
            return this.from.getStatus();
        }

        public String getHeader(String name) {
            return this.from.getHeader(name);
        }

        public Collection<String> getHeaders(String name) {
            return this.from.getHeaders(name);
        }

        public Collection<String> getHeaderNames() {
            return this.from.getHeaderNames();
        }

        public void setTrailerFields(Supplier<Map<String, String>> supplier) {
            this.from.setTrailerFields(supplier);
        }

        public Supplier<Map<String, String>> getTrailerFields() {
            return this.from.getTrailerFields();
        }

        @Override
        public jakarta.servlet.ServletResponse toJakartaServletResponse() {
            return this.from;
        }

        @Override
        public jakarta.servlet.http.HttpServletResponse toJakartaHttpServletResponse() {
            return this.from;
        }
    }
}

