/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.xml;

import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReplaceNamespaceTag
extends TagSupport {
    private String fromNamespace;
    private String toNamespace;

    public void doTag(XMLOutput output) throws MissingAttributeException, JellyTagException {
        final String fromURI = this.fromNamespace != null ? this.fromNamespace : "";
        final String toURI = this.toNamespace != null ? this.toNamespace : "";
        XMLOutput newOutput = output;
        if (!toURI.equals(fromURI)) {
            newOutput = new XMLOutput((ContentHandler)output){

                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    super.startElement(this.replaceURI(uri), localName, qName, this.replaceURI(atts));
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    super.endElement(this.replaceURI(uri), localName, qName);
                }

                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    super.startPrefixMapping(prefix, this.replaceURI(uri));
                }

                private String replaceURI(String uri) {
                    String newUri = uri;
                    if (fromURI.equals(uri != null ? uri : "")) {
                        newUri = toURI;
                    }
                    return newUri;
                }

                private Attributes replaceURI(Attributes atts) {
                    AttributesImpl newAttsImpl = new AttributesImpl();
                    for (int i = 0; i < atts.getLength(); ++i) {
                        String QName = atts.getQName(i);
                        String newUri = atts.getURI(i);
                        int idx = QName.indexOf(58);
                        if (idx >= 0) {
                            newUri = this.replaceURI(newUri);
                        }
                        newAttsImpl.addAttribute(newUri, atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
                    }
                    return newAttsImpl;
                }
            };
        }
        this.invokeBody(newOutput);
    }

    public String getFromURI() {
        return this.fromNamespace;
    }

    public void setFromURI(String namespace) {
        this.fromNamespace = namespace;
    }

    public String getToURI() {
        return this.toNamespace;
    }

    public void setToURI(String namespace) {
        this.toNamespace = namespace;
    }
}

