/*
 * Decompiled with CFR 0.152.
 */
package jenkins.health;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import java.util.Collection;
import jenkins.health.HealthCheck;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.json.JsonHttpResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class HealthCheckAction
extends InvisibleAction
implements UnprotectedRootAction {
    @Override
    public String getUrlName() {
        return "health";
    }

    public HttpResponse doIndex() {
        boolean success = true;
        JSONArray failing = new JSONArray();
        for (HealthCheck healthCheck : ExtensionList.lookup(HealthCheck.class)) {
            boolean check = healthCheck.check();
            success &= check;
            if (check) continue;
            failing.add((Object)healthCheck.getName());
        }
        JSONObject payload = new JSONObject().element("status", success);
        if (!success) {
            payload = payload.element("failures", (Collection)failing);
        }
        return new JsonHttpResponse(payload, success ? 200 : 503);
    }
}

