/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import java.util.List;

public class UnionSearchIndex
implements SearchIndex {
    private final SearchIndex lhs;
    private final SearchIndex rhs;

    public static SearchIndex combine(SearchIndex ... sets) {
        SearchIndex p = EMPTY;
        for (SearchIndex q : sets) {
            if (q == null || q == EMPTY) continue;
            p = p == EMPTY ? q : new UnionSearchIndex(p, q);
        }
        return p;
    }

    public UnionSearchIndex(SearchIndex lhs, SearchIndex rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public void find(String token, List<SearchItem> result) {
        this.lhs.find(token, result);
        this.rhs.find(token, result);
    }

    @Override
    public void suggest(String token, List<SearchItem> result) {
        this.lhs.suggest(token, result);
        this.rhs.suggest(token, result);
    }
}

