/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.util.DelegatingClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;

public class MaskingClassLoader
extends DelegatingClassLoader {
    private final List<String> masksClasses;
    private final List<String> masksResources;

    public MaskingClassLoader(ClassLoader parent, String ... masks) {
        this(parent, Arrays.asList(masks));
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> masks) {
        super("Masking ClassLoader of " + parent.getName(), parent);
        this.masksClasses = List.copyOf(masks);
        this.masksResources = masks.stream().map(mask -> mask.replace('.', '/')).collect(Collectors.toUnmodifiableList());
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String mask : this.masksClasses) {
            if (!name.startsWith(mask)) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if (this.isMasked(name)) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isMasked(name)) {
            return Collections.emptyEnumeration();
        }
        return super.getResources(name);
    }

    private boolean isMasked(String name) {
        for (String mask : this.masksResources) {
            if (!name.startsWith(mask)) continue;
            return true;
        }
        return false;
    }
}

