/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugContext {
    private List<LogRecord> logRecords = new ArrayList<LogRecord>();
    private Map<String, List<String>> tracingHeaders = new HashMap<String, List<String>>();
    private final long startTimestamp = System.nanoTime();
    private final Level tracingLevel;
    private String sessionId = null;

    public DebugContext(TracingThreshold tracingThreshold) {
        this.tracingLevel = TracingThreshold.SUMMARY == tracingThreshold ? Level.FINE : Level.FINER;
    }

    public DebugContext() {
        this.tracingLevel = Level.OFF;
    }

    public void appendLogMessage(Logger logger, Level loggingLevel, Type type, Object ... messageParts) {
        this.appendLogMessageWithThrowable(logger, loggingLevel, type, null, messageParts);
    }

    public void appendTraceMessage(Logger logger, Level loggingLevel, Type type, Object ... messageParts) {
        this.appendTraceMessageWithThrowable(logger, loggingLevel, type, null, messageParts);
    }

    public void appendLogMessageWithThrowable(Logger logger, Level loggingLevel, Type type, Throwable t, Object ... messageParts) {
        if (logger.isLoggable(loggingLevel)) {
            String message = this.stringifyMessageParts(messageParts);
            if (this.sessionId == null) {
                this.logRecords.add(new LogRecord(logger, loggingLevel, type, message, t, false));
            } else if (t != null) {
                logger.log(loggingLevel, this.formatLogMessage(message, type, System.nanoTime()), t);
            } else {
                logger.log(loggingLevel, this.formatLogMessage(message, type, System.nanoTime()));
            }
        }
    }

    public void appendTraceMessageWithThrowable(Logger logger, Level loggingLevel, Type type, Throwable t, Object ... messageParts) {
        if (this.tracingLevel.intValue() <= loggingLevel.intValue()) {
            String message = this.stringifyMessageParts(messageParts);
            this.appendTracingHeader(message);
        }
        this.appendLogMessageWithThrowable(logger, loggingLevel, type, t, messageParts);
    }

    public void appendStandardOutputMessage(Type type, String message) {
        if (this.sessionId == null) {
            this.logRecords.add(new LogRecord(null, Level.OFF, type, message, null, true));
        } else {
            System.out.println(this.formatLogMessage(message, type, System.nanoTime()));
        }
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.flush();
    }

    public void flush() {
        if (this.sessionId == null) {
            this.sessionId = UUID.randomUUID().toString();
        }
        for (LogRecord logRecord : this.logRecords) {
            if (logRecord.printToSout) {
                System.out.println(this.formatLogMessage(logRecord.message, logRecord.type, logRecord.timestamp));
                continue;
            }
            if (!logRecord.logger.isLoggable(logRecord.loggingLevel)) continue;
            if (logRecord.t != null) {
                logRecord.logger.log(logRecord.loggingLevel, this.formatLogMessage(logRecord.message, logRecord.type, logRecord.timestamp), logRecord.t);
                continue;
            }
            logRecord.logger.log(logRecord.loggingLevel, this.formatLogMessage(logRecord.message, logRecord.type, logRecord.timestamp));
        }
        this.logRecords.clear();
    }

    public Map<String, List<String>> getTracingHeaders() {
        return this.tracingHeaders;
    }

    private void appendTracingHeader(String message) {
        String headerName = "X-Tyrus-Tracing-" + String.format("%02d", this.tracingHeaders.size());
        this.tracingHeaders.put(headerName, Arrays.asList("[" + (System.nanoTime() - this.startTimestamp) / 1000000L + " ms] " + message));
    }

    private String formatLogMessage(String message, Type type, long timestamp) {
        StringBuilder formattedMessage = new StringBuilder();
        ArrayList<String> messageLines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(message, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            messageLines.add(tokenizer.nextToken());
        }
        String prefix = type == Type.MESSAGE_IN ? "< " : (type == Type.MESSAGE_OUT ? "> " : "* ");
        boolean isFirst = true;
        for (String line : messageLines) {
            if (isFirst) {
                formattedMessage.append(prefix).append("Session ").append(this.sessionId).append(" ");
                formattedMessage.append("[").append((timestamp - this.startTimestamp) / 1000000L).append(" ms]: ");
                formattedMessage.append(line);
                isFirst = false;
                continue;
            }
            if (!"\n".equals(line)) {
                formattedMessage.append(prefix);
            }
            formattedMessage.append(line);
        }
        return formattedMessage.toString();
    }

    private String stringifyMessageParts(Object ... messageParts) {
        StringBuilder sb = new StringBuilder();
        for (Object messagePart : messageParts) {
            sb.append(messagePart);
        }
        return sb.toString();
    }

    public static enum TracingThreshold {
        SUMMARY,
        TRACE;

    }

    public static enum TracingType {
        OFF,
        ON_DEMAND,
        ALL;

    }

    public static enum Type {
        MESSAGE_IN,
        MESSAGE_OUT,
        OTHER;

    }

    private static class LogRecord {
        private Logger logger;
        private Level loggingLevel;
        private Type type;
        private String message;
        private Throwable t;
        private boolean printToSout;
        private long timestamp;

        LogRecord(Logger logger, Level loggingLevel, Type Type2, String message, Throwable t, boolean printToSout) {
            this.logger = logger;
            this.loggingLevel = loggingLevel;
            this.type = Type2;
            this.message = message;
            this.t = t;
            this.printToSout = printToSout;
            this.timestamp = System.nanoTime();
        }
    }
}

