/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.protocol.IOHub;
import org.jenkinsci.remoting.protocol.NetworkLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.IOUtils;

public class BIONetworkLayer
extends NetworkLayer {
    private static final Logger LOGGER = Logger.getLogger(BIONetworkLayer.class.getName());
    private final ReadableByteChannel in;
    private final WritableByteChannel out;
    private final Reader reader = new Reader();
    private final Writer writer = new Writer();
    private final ByteBufferQueue writeQueue = new ByteBufferQueue(8192);
    private boolean starting;
    private boolean running;

    public BIONetworkLayer(IOHub ioHub, ReadableByteChannel in, WritableByteChannel out) {
        super(ioHub);
        this.in = in;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(@NonNull ByteBuffer data) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] SEND: {1} bytes", new Object[]{this.stack().name(), data.remaining()});
        }
        if (!data.hasRemaining()) {
            return;
        }
        if (!this.out.isOpen()) {
            throw new ClosedChannelException();
        }
        ByteBufferQueue byteBufferQueue = this.writeQueue;
        synchronized (byteBufferQueue) {
            if (!this.writeQueue.hasRemaining()) {
                this.getIoHub().execute(this.writer);
            }
            this.writeQueue.put(data);
        }
    }

    @Override
    public void doCloseRecv() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Closing RECV", this.stack().name());
        }
        if (this.in.isOpen()) {
            IOUtils.closeQuietly(this.in);
        }
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.starting || this.running) {
            return;
        }
        if (!this.getIoHub().isOpen()) {
            throw new IllegalStateException("IOHub must be open: " + String.valueOf(this.getIoHub()));
        }
        this.starting = true;
        this.getIoHub().execute(this.reader);
        super.start();
    }

    @Override
    public void doCloseSend() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Closing SEND", this.stack().name());
        }
        if (this.out.isOpen()) {
            IOUtils.closeQuietly(this.out);
        }
    }

    @Override
    public boolean isSendOpen() {
        return this.out.isOpen();
    }

    static /* synthetic */ ProtocolStack access$000(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ ByteBuffer access$100(BIONetworkLayer x0) {
        return x0.acquire();
    }

    static /* synthetic */ void access$200(BIONetworkLayer x0, ByteBuffer x1) {
        x0.release(x1);
    }

    static /* synthetic */ ProtocolStack access$300(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ ProtocolStack access$400(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ ByteBuffer access$500(BIONetworkLayer x0) {
        return x0.acquire();
    }

    static /* synthetic */ boolean access$600(BIONetworkLayer x0) {
        return x0.isRecvOpen();
    }

    static /* synthetic */ void access$700(BIONetworkLayer x0) {
        x0.onRecvClosed();
    }

    static /* synthetic */ void access$800(BIONetworkLayer x0) {
        x0.onRecvClosed();
    }

    static /* synthetic */ ProtocolStack access$900(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ void access$1000(BIONetworkLayer x0) {
        x0.onRecvClosed();
    }

    static /* synthetic */ ProtocolStack access$1100(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ void access$1200(BIONetworkLayer x0) {
        x0.onRecvClosed();
    }

    static /* synthetic */ ProtocolStack access$1300(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ void access$1400(BIONetworkLayer x0, ByteBuffer x1) throws IOException {
        x0.onRead(x1);
    }

    static /* synthetic */ void access$1500(BIONetworkLayer x0) {
        x0.onRecvClosed();
    }

    static /* synthetic */ void access$1600(BIONetworkLayer x0, ByteBuffer x1) {
        x0.release(x1);
    }

    static /* synthetic */ ProtocolStack access$1700(BIONetworkLayer x0) {
        return x0.stack();
    }

    static /* synthetic */ ProtocolStack access$1800(BIONetworkLayer x0) {
        return x0.stack();
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class Writer
    implements Runnable {
        private Writer() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public synchronized void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

