/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Channel;
import hudson.remoting.ChunkHeader;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.ByteBufferQueueOutputStream;
import org.jenkinsci.remoting.util.FastByteBufferQueueInputStream;
import org.jenkinsci.remoting.util.IOUtils;

public abstract class AbstractByteBufferCommandTransport
extends CommandTransport {
    private static final Logger LOGGER = Logger.getLogger(AbstractByteBufferCommandTransport.class.getName());
    private static final int READ_STATE_NEED_HEADER = 0;
    private static final int READ_STATE_MORE_HEADER = 1;
    private static final int READ_STATE_FRAME_BODY = 2;
    private static final int READ_STATE_COMMAND_READY = 3;
    private Channel channel;
    @Deprecated
    private final ByteBuffer writeChunkHeader;
    private int transportFrameSize = 8192;
    @Deprecated
    private ByteBuffer writeChunkBody;
    private ByteBuffer writeChunkCombined;
    private CommandTransport.CommandReceiver receiver;
    private final ByteBufferQueue receiveQueue = new ByteBufferQueue(this.transportFrameSize);
    private int readState;
    private int readFrameRemaining;
    private int readFrameHeader;
    private int readCommandIndex = 0;
    private int[] readCommandSizes = new int[16];
    private final ByteBufferQueue sendStaging = new ByteBufferQueue(this.transportFrameSize);

    @Deprecated
    protected AbstractByteBufferCommandTransport() {
        this(false);
    }

    protected AbstractByteBufferCommandTransport(boolean combineBuffers) {
        if (combineBuffers) {
            this.writeChunkHeader = null;
            this.writeChunkBody = null;
            this.writeChunkCombined = ByteBuffer.allocate(this.transportFrameSize + 2);
        } else {
            this.writeChunkHeader = ByteBuffer.allocate(2);
            this.writeChunkBody = ByteBuffer.allocate(this.transportFrameSize);
            this.writeChunkCombined = null;
        }
    }

    @Deprecated
    protected void write(ByteBuffer header, ByteBuffer data) throws IOException {
        throw new AbstractMethodError("implement write(ByteBuffer, ByteBuffer) if !combineBuffers");
    }

    protected void write(ByteBuffer headerAndData) throws IOException {
        throw new AbstractMethodError("implement write(ByteBuffer) if combineBuffers");
    }

    @SuppressFBWarnings(value={"SF_DEAD_STORE_DUE_TO_SWITCH_FALLTHROUGH", "SF_SWITCH_FALLTHROUGH"}, justification="TODO: Remove when https://github.com/spotbugs/spotbugs/issues/3617 is fixed")
    public final void receive(@NonNull ByteBuffer data) throws IOException, InterruptedException {
        while (this.receiver != null && this.readCommandIndex > 0) {
            this.processCommand();
        }
        block7: while (data.hasRemaining() || this.readState == 3) {
            switch (this.readState) {
                case 0: {
                    if (data.remaining() >= 2) {
                        this.readFrameHeader = ChunkHeader.read(data);
                        this.readFrameRemaining = ChunkHeader.length(this.readFrameHeader);
                        this.readState = 2;
                        continue block7;
                    }
                    this.readFrameHeader = data.get();
                    this.readState = 1;
                    continue block7;
                }
                case 1: {
                    this.readFrameHeader = ChunkHeader.parse(this.readFrameHeader, (int)data.get());
                    this.readFrameRemaining = ChunkHeader.length(this.readFrameHeader);
                    this.readState = 2;
                    continue block7;
                }
                case 2: {
                    if (data.remaining() < this.readFrameRemaining) {
                        int n = this.readCommandIndex;
                        this.readCommandSizes[n] = this.readCommandSizes[n] + data.remaining();
                        this.readFrameRemaining -= data.remaining();
                        this.receiveQueue.put(data);
                        continue block7;
                    }
                    int n = this.readCommandIndex;
                    this.readCommandSizes[n] = this.readCommandSizes[n] + this.readFrameRemaining;
                    int oldLimit = data.limit();
                    ((Buffer)data).limit(data.position() + this.readFrameRemaining);
                    this.receiveQueue.put(data);
                    ((Buffer)data).limit(oldLimit);
                    this.readFrameRemaining = 0;
                    if (ChunkHeader.isLast(this.readFrameHeader)) {
                        this.readState = 3;
                        continue block7;
                    }
                    this.readState = 0;
                    continue block7;
                }
                case 3: {
                    ++this.readCommandIndex;
                    if (this.readCommandIndex > this.readCommandSizes.length) {
                        this.readCommandSizes = Arrays.copyOf(this.readCommandSizes, this.readCommandSizes.length * 2);
                    }
                    this.readCommandSizes[this.readCommandIndex] = 0;
                    this.readState = 0;
                    if (this.receiver == null) continue block7;
                    this.processCommand();
                    continue block7;
                }
            }
            throw new IllegalStateException("Unknown readState = " + this.readState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand() throws IOException {
        try {
            FastByteBufferQueueInputStream is = new FastByteBufferQueueInputStream(this.receiveQueue, this.readCommandSizes[0]);
            try {
                Command cmd = Command.readFrom(this.channel, is, this.readCommandSizes[0]);
                this.receiver.handle(cmd);
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to construct Command in channel " + this.channel.getName(), e);
            }
            finally {
                int available = is.available();
                if (available > 0 && is.skip(available) != (long)available) {
                    LOGGER.log(Level.FINE, "Failed to skip remainder of Command");
                }
                IOUtils.closeQuietly(is);
            }
        }
        finally {
            if (this.readCommandIndex == 1) {
                if (this.readCommandSizes.length > 16) {
                    int temp = this.readCommandSizes[1];
                    this.readCommandSizes = new int[16];
                    this.readCommandSizes[0] = temp;
                } else {
                    this.readCommandSizes[0] = this.readCommandSizes[1];
                }
                this.readCommandIndex = 0;
            } else {
                System.arraycopy(this.readCommandSizes, 1, this.readCommandSizes, 0, this.readCommandIndex);
                --this.readCommandIndex;
            }
        }
    }

    public void setFrameSize(int transportFrameSize) {
        if (transportFrameSize <= 0 || transportFrameSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.transportFrameSize = transportFrameSize;
        if (this.writeChunkHeader == null) {
            this.writeChunkCombined = ByteBuffer.allocate(transportFrameSize + 2);
        } else {
            this.writeChunkBody = ByteBuffer.allocate(transportFrameSize);
        }
    }

    @Nullable
    protected Channel getChannel() {
        return this.channel;
    }

    @Override
    public final synchronized void setup(Channel channel, CommandTransport.CommandReceiver receiver) {
        this.channel = channel;
        this.receiver = receiver;
        try {
            while (receiver != null && this.readCommandIndex > 0) {
                this.processCommand();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not flush receive buffer queue", e);
        }
    }

    @Override
    public final void write(Command cmd, boolean last) throws IOException {
        int frame;
        long remaining;
        ByteBufferQueueOutputStream bqos = new ByteBufferQueueOutputStream(this.sendStaging);
        try (ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream(bqos);){
            cmd.writeTo(this.channel, oos);
        }
        this.channel.notifyWrite(cmd, remaining);
        for (remaining = this.sendStaging.remaining(); remaining > 0L; remaining -= (long)frame) {
            int n = frame = remaining > (long)this.transportFrameSize ? this.transportFrameSize : (int)remaining;
            if (this.writeChunkHeader == null) {
                ((Buffer)this.writeChunkCombined).clear();
                ((Buffer)this.writeChunkCombined).limit(frame + 2);
                ChunkHeader.write(this.writeChunkCombined, frame, remaining > (long)this.transportFrameSize);
                this.sendStaging.get(this.writeChunkCombined);
                ((Buffer)this.writeChunkCombined).flip();
                this.write(this.writeChunkCombined);
                continue;
            }
            ((Buffer)this.writeChunkHeader).clear();
            ChunkHeader.write(this.writeChunkHeader, frame, remaining > (long)this.transportFrameSize);
            ((Buffer)this.writeChunkHeader).flip();
            ((Buffer)this.writeChunkBody).clear();
            ((Buffer)this.writeChunkBody).limit(frame);
            this.sendStaging.get(this.writeChunkBody);
            ((Buffer)this.writeChunkBody).flip();
            this.write(this.writeChunkHeader, this.writeChunkBody);
        }
    }

    public void terminate(IOException e) {
        if (this.receiver != null) {
            this.receiver.terminate(e);
        }
    }
}

