/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractDecimalMorpher;

public final class FloatMorpher
extends AbstractDecimalMorpher {
    private float defaultValue;

    public FloatMorpher() {
    }

    public FloatMorpher(float defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FloatMorpher)) {
            return false;
        }
        FloatMorpher other = (FloatMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(Float.valueOf(this.getDefaultValue()), Float.valueOf(other.getDefaultValue()));
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(Float.valueOf(this.getDefaultValue()));
        }
        return 17;
    }

    public float morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        float i = 0.0f;
        try {
            i = Float.parseFloat(String.valueOf(value));
            return i;
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    @Override
    public Class morphsTo() {
        return Float.TYPE;
    }
}

