/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jelly.DynaTagSupport;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicTag
extends DynaTagSupport {
    private static final Log log = LogFactory.getLog(DynamicTag.class);
    private Script template;
    private Map attributes = new HashMap();

    public DynamicTag() {
    }

    public DynamicTag(Script template) {
        this.template = template;
    }

    @Override
    public void doTag(XMLOutput output) throws JellyTagException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking dynamic tag with attributes: " + String.valueOf(this.attributes)));
        }
        this.attributes.put("org.apache.commons.jelly.body", this.getBody());
        this.attributes.put("org.apache.commons.jelly.body.scope", this.context);
        JellyContext newJellyContext = this.context.newJellyContext(this.attributes);
        HashMap<String, DynamicTag> attrMap = new HashMap<String, DynamicTag>();
        attrMap.put("ownerTag", this);
        for (String key : this.attributes.keySet()) {
            if (!key.endsWith("Attr")) continue;
            Object value = this.attributes.get(key);
            attrMap.put(key, (DynamicTag)value);
            attrMap.put(key.substring(0, key.length() - 4), (DynamicTag)value);
        }
        newJellyContext.setVariable("attrs", attrMap);
        this.getTemplate().run(newJellyContext, output);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        this.attributes.put(name + "Attr", value);
    }

    public Script getTemplate() {
        return this.template;
    }

    public void setTemplate(Script template) {
        this.template = template;
    }

    public Map getAttributes() {
        return this.attributes;
    }
}

