/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Item;
import hudson.security.AccessControlled;
import jenkins.model.FullyNamedModelObject;

public interface ITask
extends FullyNamedModelObject {
    default public boolean hasAbortPermission() {
        ITask iTask = this;
        if (iTask instanceof AccessControlled) {
            AccessControlled ac = (AccessControlled)((Object)iTask);
            return ac.hasPermission(Item.CANCEL);
        }
        return true;
    }

    default public boolean hasReadPermission() {
        ITask iTask = this;
        if (iTask instanceof AccessControlled) {
            AccessControlled ac = (AccessControlled)((Object)iTask);
            return ac.hasPermission(Item.READ);
        }
        return true;
    }

    @Override
    default public String getFullDisplayName() {
        return this.getDisplayName();
    }

    @CheckForNull
    public String getUrl();
}

