/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.primitive;

import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.primitive.AbstractPrimitiveMorpher;

public final class CharMorpher
extends AbstractPrimitiveMorpher {
    private char defaultValue;

    public CharMorpher() {
    }

    public CharMorpher(char defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharMorpher)) {
            return false;
        }
        CharMorpher other = (CharMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(Character.valueOf(this.getDefaultValue()), Character.valueOf(other.getDefaultValue()));
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public char getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(Character.valueOf(this.getDefaultValue()));
        }
        return 17;
    }

    public char morph(Object value) {
        if (value == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException("value is null");
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue();
        }
        String s = String.valueOf(value);
        if (s.length() > 0) {
            return s.charAt(0);
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Can't morph value: " + String.valueOf(value));
    }

    @Override
    public Class morphsTo() {
        return Character.TYPE;
    }
}

