/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.EvaluationTrace;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class Dispatcher {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Used in JTH and others.")
    public static boolean TRACE = Boolean.getBoolean("stapler.trace");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Legacy switch.")
    public static boolean TRACE_PER_REQUEST = Boolean.getBoolean("stapler.trace.per-request");
    private static final Logger LOGGER = Logger.getLogger(Dispatcher.class.getName());

    public abstract boolean dispatch(RequestImpl var1, ResponseImpl var2, Object var3) throws IOException, ServletException, IllegalAccessException, InvocationTargetException;

    public abstract String toString();

    public static boolean traceable() {
        return TRACE || TRACE_PER_REQUEST || LOGGER.isLoggable(Level.FINE);
    }

    public static void traceEval(StaplerRequest2 req, StaplerResponse2 rsp, Object node) {
        Dispatcher.trace(req, rsp, String.format("-> evaluate(%s%s,\"%s\")", node == null ? "null" : "<" + node.toString() + ">", node == null ? "" : " :" + node.getClass().getName(), ((RequestImpl)req).tokens.assembleOriginalRestOfPath()));
    }

    public static void anonymizedTraceEval(StaplerRequest2 req, StaplerResponse2 rsp, Object node, String format, String ... args) {
        ArrayList<String> arg = new ArrayList<String>();
        arg.add(node == null ? "(null)" : node.getClass().getName());
        arg.addAll(Arrays.asList(args));
        EvaluationTrace.ApplicationTracer.trace(req, String.format(format, arg.toArray()));
    }

    public static void traceEval(StaplerRequest2 req, StaplerResponse2 rsp, Object node, String prefix, String suffix) {
        Dispatcher.trace(req, rsp, String.format("-> evaluate(%s<%s>%s,\"%s\")", prefix, node, suffix, ((RequestImpl)req).tokens.assembleOriginalRestOfPath()));
    }

    public static void traceEval(StaplerRequest2 req, StaplerResponse2 rsp, Object node, String expression) {
        Dispatcher.trace(req, rsp, String.format("-> evaluate(<%s>.%s,\"%s\")", node, expression, ((RequestImpl)req).tokens.assembleOriginalRestOfPath()));
    }

    public static void trace(StaplerRequest2 req, StaplerResponse2 rsp, String msg, Object ... args) {
        Dispatcher.trace(req, rsp, String.format(msg, args));
    }

    public static void trace(StaplerRequest2 req, StaplerResponse2 rsp, String msg) {
        if (Dispatcher.isTraceEnabled(req)) {
            EvaluationTrace.get(req).trace(rsp, msg);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(msg);
        }
    }

    public static boolean isTraceEnabled(StaplerRequest2 req) {
        if (TRACE) {
            return true;
        }
        return TRACE_PER_REQUEST && "true".equals(req.getHeader("X-Stapler-Trace"));
    }
}

