/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.servlet;

import io.jenkins.servlet.ServletOutputStreamWrapper;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.ServletResponse;

public class ServletResponseWrapper {
    public static jakarta.servlet.ServletResponse toJakartaServletResponse(ServletResponse from) {
        if (from instanceof JavaxServletResponseWrapper) {
            JavaxServletResponseWrapper javax = (JavaxServletResponseWrapper)from;
            return javax.toJakartaServletResponse();
        }
        return new JakartaServletResponseWrapperImpl(from);
    }

    public static ServletResponse fromJakartaServletResponse(jakarta.servlet.ServletResponse from) {
        if (from instanceof JakartaServletResponseWrapper) {
            JakartaServletResponseWrapper jakarta = (JakartaServletResponseWrapper)from;
            return jakarta.toJavaxServletResponse();
        }
        return new JavaxServletResponseWrapperImpl(from);
    }

    public static interface JavaxServletResponseWrapper {
        public jakarta.servlet.ServletResponse toJakartaServletResponse();
    }

    private static class JakartaServletResponseWrapperImpl
    implements jakarta.servlet.ServletResponse,
    JakartaServletResponseWrapper {
        private final ServletResponse from;

        JakartaServletResponseWrapperImpl(ServletResponse from) {
            this.from = Objects.requireNonNull(from);
        }

        public String getCharacterEncoding() {
            return this.from.getCharacterEncoding();
        }

        public String getContentType() {
            return this.from.getContentType();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return ServletOutputStreamWrapper.toJakartaServletOutputStream(this.from.getOutputStream());
        }

        public PrintWriter getWriter() throws IOException {
            return this.from.getWriter();
        }

        public void setCharacterEncoding(String charset) {
            this.from.setCharacterEncoding(charset);
        }

        public void setContentLength(int len) {
            this.from.setContentLength(len);
        }

        public void setContentLengthLong(long len) {
            this.from.setContentLengthLong(len);
        }

        public void setContentType(String type) {
            this.from.setContentType(type);
        }

        public void setBufferSize(int size) {
            this.from.setBufferSize(size);
        }

        public int getBufferSize() {
            return this.from.getBufferSize();
        }

        public void flushBuffer() throws IOException {
            this.from.flushBuffer();
        }

        public void resetBuffer() {
            this.from.resetBuffer();
        }

        public boolean isCommitted() {
            return this.from.isCommitted();
        }

        public void reset() {
            this.from.reset();
        }

        public void setLocale(Locale loc) {
            this.from.setLocale(loc);
        }

        public Locale getLocale() {
            return this.from.getLocale();
        }

        @Override
        public ServletResponse toJavaxServletResponse() {
            return this.from;
        }
    }

    public static interface JakartaServletResponseWrapper {
        public ServletResponse toJavaxServletResponse();
    }

    private static class JavaxServletResponseWrapperImpl
    implements ServletResponse,
    JavaxServletResponseWrapper {
        private final jakarta.servlet.ServletResponse from;

        JavaxServletResponseWrapperImpl(jakarta.servlet.ServletResponse from) {
            this.from = Objects.requireNonNull(from);
        }

        public String getCharacterEncoding() {
            return this.from.getCharacterEncoding();
        }

        public String getContentType() {
            return this.from.getContentType();
        }

        public javax.servlet.ServletOutputStream getOutputStream() throws IOException {
            return ServletOutputStreamWrapper.fromJakartaServletOutputStream(this.from.getOutputStream());
        }

        public PrintWriter getWriter() throws IOException {
            return this.from.getWriter();
        }

        public void setCharacterEncoding(String charset) {
            this.from.setCharacterEncoding(charset);
        }

        public void setContentLength(int len) {
            this.from.setContentLength(len);
        }

        public void setContentLengthLong(long len) {
            this.from.setContentLengthLong(len);
        }

        public void setContentType(String type) {
            this.from.setContentType(type);
        }

        public void setBufferSize(int size) {
            this.from.setBufferSize(size);
        }

        public int getBufferSize() {
            return this.from.getBufferSize();
        }

        public void flushBuffer() throws IOException {
            this.from.flushBuffer();
        }

        public void resetBuffer() {
            this.from.resetBuffer();
        }

        public boolean isCommitted() {
            return this.from.isCommitted();
        }

        public void reset() {
            this.from.reset();
        }

        public void setLocale(Locale loc) {
            this.from.setLocale(loc);
        }

        public Locale getLocale() {
            return this.from.getLocale();
        }

        @Override
        public jakarta.servlet.ServletResponse toJakartaServletResponse() {
            return this.from;
        }
    }
}

