/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece;

import io.jenkins.cli.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PrivateKey;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece.BCMcElieceCCA2PublicKey;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.spec.McElieceCCA2KeyGenParameterSpec;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2Parameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.legacy.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class McElieceCCA2KeyPairGeneratorSpi
extends KeyPairGenerator {
    private McElieceCCA2KeyPairGenerator kpg;

    public McElieceCCA2KeyPairGeneratorSpi() {
        super("McEliece-CCA2");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceCCA2KeyPairGenerator();
        McElieceCCA2KeyGenParameterSpec mcElieceCCA2KeyGenParameterSpec = (McElieceCCA2KeyGenParameterSpec)algorithmParameterSpec;
        McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(secureRandom, new McElieceCCA2Parameters(mcElieceCCA2KeyGenParameterSpec.getM(), mcElieceCCA2KeyGenParameterSpec.getT(), mcElieceCCA2KeyGenParameterSpec.getDigest()));
        this.kpg.init(mcElieceCCA2KeyGenerationParameters);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.kpg = new McElieceCCA2KeyPairGenerator();
        McElieceCCA2KeyGenParameterSpec mcElieceCCA2KeyGenParameterSpec = (McElieceCCA2KeyGenParameterSpec)algorithmParameterSpec;
        McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new McElieceCCA2Parameters(mcElieceCCA2KeyGenParameterSpec.getM(), mcElieceCCA2KeyGenParameterSpec.getT(), mcElieceCCA2KeyGenParameterSpec.getDigest()));
        this.kpg.init(mcElieceCCA2KeyGenerationParameters);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.kpg = new McElieceCCA2KeyPairGenerator();
        McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(secureRandom, new McElieceCCA2Parameters());
        this.kpg.init(mcElieceCCA2KeyGenerationParameters);
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.kpg.generateKeyPair();
        McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters = (McElieceCCA2PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters = (McElieceCCA2PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        return new KeyPair(new BCMcElieceCCA2PublicKey(mcElieceCCA2PublicKeyParameters), new BCMcElieceCCA2PrivateKey(mcElieceCCA2PrivateKeyParameters));
    }
}

