/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.array;

import java.lang.reflect.Array;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.array.AbstractArrayMorpher;
import net.sf.ezmorph.primitive.CharMorpher;

public final class CharacterObjectArrayMorpher
extends AbstractArrayMorpher {
    private static final Class CHARACTER_OBJECT_ARRAY_CLASS = Character[].class;
    private Character defaultValue;

    public CharacterObjectArrayMorpher() {
        super(false);
    }

    public CharacterObjectArrayMorpher(Character defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CharacterObjectArrayMorpher)) {
            return false;
        }
        CharacterObjectArrayMorpher other = (CharacterObjectArrayMorpher)obj;
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public Character getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        if (this.isUseDefault()) {
            return Objects.hashCode(this.getDefaultValue());
        }
        return 17;
    }

    @Override
    public Object morph(Object array) {
        if (array == null) {
            return null;
        }
        if (CHARACTER_OBJECT_ARRAY_CLASS.isAssignableFrom(array.getClass())) {
            return (Character[])array;
        }
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            int dims = this.getDimensions(array.getClass());
            int[] dimensions = this.createDimensions(dims, length);
            Object result = Array.newInstance(Character.class, dimensions);
            if (dims == 1) {
                CharMorpher morpher = null;
                if (this.isUseDefault()) {
                    if (this.defaultValue == null) {
                        for (int index = 0; index < length; ++index) {
                            Array.set(result, index, null);
                        }
                        return result;
                    }
                    morpher = new CharMorpher(this.defaultValue.charValue());
                } else {
                    morpher = new CharMorpher();
                }
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, Character.valueOf(morpher.morph(Array.get(array, index))));
                }
            } else {
                for (int index = 0; index < length; ++index) {
                    Array.set(result, index, this.morph(Array.get(array, index)));
                }
            }
            return result;
        }
        throw new MorphException("argument is not an array: " + String.valueOf(array.getClass()));
    }

    @Override
    public Class morphsTo() {
        return CHARACTER_OBJECT_ARRAY_CLASS;
    }
}

