/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression.xpath;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.dom4j.Dom4jXPath;

public class XPathExpression
extends ExpressionSupport
implements VariableContext {
    private Log log = LogFactory.getLog(XPathExpression.class);
    private String text;
    private Expression xpathExpr;
    private JellyContext context;
    private Map uris;

    public XPathExpression() {
    }

    public XPathExpression(String text, Expression xpathExpr, TagScript tagScript) {
        this.text = text;
        this.xpathExpr = xpathExpr;
        Map namespaceContext = tagScript.getNamespaceContext();
        this.uris = this.createUriMap(namespaceContext);
    }

    public String toString() {
        return this.getExpressionText();
    }

    @Override
    public String getExpressionText() {
        return this.text;
    }

    @Override
    public Object evaluate(JellyContext context) {
        this.context = context;
        try {
            Dom4jXPath xpath = new Dom4jXPath(this.xpathExpr.evaluateAsString(context));
            xpath.setVariableContext((VariableContext)this);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting the namespace context to be: " + String.valueOf(this.uris)));
            }
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(this.uris));
            return xpath;
        }
        catch (JaxenException e) {
            this.log.error((Object)"Error constructing xpath", (Throwable)e);
            return null;
        }
    }

    public Object getVariableValue(String namespaceURI, String prefix, String localName) {
        Object value = this.context.getVariable(localName);
        return value;
    }

    protected Map createUriMap(Map namespaceContext) {
        Hashtable uris = new Hashtable(namespaceContext.size());
        for (Map.Entry entry : namespaceContext.entrySet()) {
            String prefix = (String)entry.getKey();
            if (prefix == null || prefix.length() == 0) continue;
            uris.put(prefix, entry.getValue());
        }
        return uris;
    }
}

