/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.util.logging.Level;
import winstone.WinstoneResourceBundle;

public class Logger {
    private static final Object semaphore = new Object();
    static boolean initialised = false;
    static boolean showThrowingThread;
    private static final java.util.logging.Logger LOGGER;

    public static void init(Level level) {
        Logger.init(level, false);
    }

    public static void init(int level) {
        Logger.init(Level.parse(String.valueOf(level)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Level level, boolean showThrowingThreadArg) {
        Object object = semaphore;
        synchronized (object) {
            if (!initialised) {
                LOGGER.setLevel(level);
                showThrowingThread = showThrowingThreadArg;
                initialised = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentDebugLevel(int level) {
        if (!initialised) {
            Logger.init(level);
        } else {
            Object object = semaphore;
            synchronized (object) {
                LOGGER.setLevel(Level.parse(String.valueOf(level)));
            }
        }
    }

    private static void logInternal(Level level, String message, Throwable error) {
        if (!initialised) {
            Logger.init(Level.INFO);
        }
        Object msg = "";
        if (showThrowingThread) {
            msg = "[" + Thread.currentThread().getName() + "] - ";
        }
        msg = (String)msg + message;
        LOGGER.log(level, (String)msg, error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object param) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, param), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object param, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, param), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object[] params, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String streamName, String messageKey, Object[] params, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), error);
    }

    public static void logDirectMessage(Level level, String streamName, String message, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, message, error);
    }

    static {
        LOGGER = java.util.logging.Logger.getLogger("winstone");
    }
}

