/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves.restarter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Engine;
import hudson.remoting.EngineListenerAdapter;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.slaves.DumbSlave;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.restarter.SlaveRestarter;

@Extension
public class JnlpSlaveRestarterInstaller
extends ComputerListener
implements Serializable {
    private static final boolean FORCE_INSTALL = Boolean.getBoolean(JnlpSlaveRestarterInstaller.class.getName() + ".forceInstall");
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveRestarterInstaller.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="method signature does not permit plumbing through the return value")
    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        if (FORCE_INSTALL || c.getNode() instanceof DumbSlave) {
            Computer.threadPoolForRemoting.submit(new Install(c, listener));
        }
    }

    private static class Install
    implements Callable<Void> {
        private final Computer c;
        private final TaskListener listener;

        Install(Computer c, TaskListener listener) {
            this.c = c;
            this.listener = listener;
        }

        @Override
        public Void call() throws Exception {
            Install.install(this.c, this.listener);
            return null;
        }

        private static void install(Computer c, TaskListener listener) {
            try {
                ArrayList<SlaveRestarter> restarters = new ArrayList<SlaveRestarter>(SlaveRestarter.all());
                VirtualChannel ch = c.getChannel();
                if (ch == null) {
                    return;
                }
                List<SlaveRestarter> effective = ch.call(new FindEffectiveRestarters(restarters));
                LOGGER.log(Level.FINE, "Effective SlaveRestarter on {0}: {1}", new Object[]{c.getName(), effective});
            }
            catch (Throwable e) {
                Functions.printStackTrace(e, listener.error("Failed to install restarter"));
            }
        }
    }

    private static final class EngineListenerAdapterImpl
    extends EngineListenerAdapter {
        private final List<SlaveRestarter> restarters;

        EngineListenerAdapterImpl(List<SlaveRestarter> restarters) {
            this.restarters = restarters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReconnect() {
            try {
                for (SlaveRestarter r : this.restarters) {
                    try {
                        Logger.getGlobal().info("Restarting agent via " + String.valueOf(r));
                        r.restart();
                    }
                    catch (Exception x) {
                        Logger.getGlobal().log(Level.SEVERE, "Failed to restart agent with " + String.valueOf(r), x);
                    }
                }
            }
            finally {
                this.restarters.clear();
            }
        }
    }

    private static class FindEffectiveRestarters
    extends MasterToSlaveCallable<List<SlaveRestarter>, IOException> {
        private final List<SlaveRestarter> restarters;

        FindEffectiveRestarters(List<SlaveRestarter> restarters) {
            this.restarters = restarters;
        }

        @Override
        public List<SlaveRestarter> call() throws IOException {
            Engine e = Engine.current();
            if (e == null) {
                return null;
            }
            this.restarters.removeIf(r -> !r.canWork());
            e.addListener(new EngineListenerAdapterImpl(this.restarters));
            return this.restarters;
        }
    }
}

