/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ByteBufferQueue {
    private static final int INITIAL_CAPACITY = 16;
    private static final int SHRINK_CAPACITY = 512;
    private static final int SHRINK_THRESHOLD = 8;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private ByteBuffer[] buffers;
    private final int bufferSize;
    private int readIndex;
    private int readPosition;
    private int writeIndex;
    private int shrinkCount;

    public ByteBufferQueue(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.buffers = new ByteBuffer[16];
        this.bufferSize = bufferSize;
        this.readIndex = 0;
        this.readPosition = 0;
        this.writeIndex = 0;
        this.buffers[this.writeIndex] = ByteBuffer.allocate(bufferSize);
    }

    private void compact() {
        while (this.readIndex < this.writeIndex && this.buffers[this.readIndex].position() == this.readPosition) {
            ++this.readIndex;
            this.readPosition = 0;
        }
        if (this.readIndex > 0) {
            System.arraycopy(this.buffers, this.readIndex, this.buffers, 0, this.writeIndex - this.readIndex + 1);
            this.writeIndex -= this.readIndex;
            this.readIndex = 0;
            Arrays.fill(this.buffers, this.writeIndex + 1, this.buffers.length, null);
        }
    }

    private void addWriteBuffer() {
        if (this.writeIndex + 1 >= this.buffers.length) {
            this.compact();
            if (this.writeIndex + 1 >= this.buffers.length) {
                this.buffers = Arrays.copyOf(this.buffers, this.buffers.length * 2);
                this.shrinkCount = 0;
            } else if (this.buffers.length >= 512 && this.writeIndex + 1 < this.buffers.length / 4) {
                ++this.shrinkCount;
                if (this.shrinkCount > 8) {
                    this.buffers = Arrays.copyOf(this.buffers, this.buffers.length / 2);
                    this.shrinkCount = 0;
                }
            } else if (this.writeIndex + 1 >= this.buffers.length * 3 / 4) {
                this.shrinkCount = 0;
            }
        }
        ++this.writeIndex;
        if (this.buffers[this.writeIndex] == null) {
            this.buffers[this.writeIndex] = this.newByteBuffer();
        } else {
            ((Buffer)this.buffers[this.writeIndex]).clear();
        }
    }

    public ByteBuffer newByteBuffer() {
        return ByteBuffer.allocate(this.bufferSize);
    }

    public void put(ByteBuffer src) {
        while (src.hasRemaining()) {
            while (!this.buffers[this.writeIndex].hasRemaining()) {
                this.addWriteBuffer();
            }
            if (src.remaining() > this.buffers[this.writeIndex].remaining()) {
                int limit = src.limit();
                ((Buffer)src).limit(src.position() + this.buffers[this.writeIndex].remaining());
                this.buffers[this.writeIndex].put(src);
                ((Buffer)src).limit(limit);
                continue;
            }
            this.buffers[this.writeIndex].put(src);
        }
    }

    public void put(byte[] src, int offset, int len) {
        while (len > 0) {
            while (!this.buffers[this.writeIndex].hasRemaining()) {
                this.addWriteBuffer();
            }
            int remaining = this.buffers[this.writeIndex].remaining();
            if (len > remaining) {
                this.buffers[this.writeIndex].put(src, offset, remaining);
                offset += remaining;
                len -= remaining;
                continue;
            }
            this.buffers[this.writeIndex].put(src, offset, len);
            return;
        }
    }

    public void put(byte b) {
        while (!this.buffers[this.writeIndex].hasRemaining()) {
            this.addWriteBuffer();
        }
        this.buffers[this.writeIndex].put(b);
    }

    public boolean hasRemaining() {
        if (this.buffers[this.readIndex].position() > this.readPosition) {
            return true;
        }
        for (int i = this.readIndex + 1; i <= this.writeIndex; ++i) {
            if (this.buffers[i].position() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemaining(int len) {
        len -= this.buffers[this.readIndex].position() - this.readPosition;
        for (int i = this.readIndex + 1; i <= this.writeIndex; ++i) {
            if ((len -= this.buffers[i].position()) > 0) continue;
            return true;
        }
        return len <= 0;
    }

    public long remaining() {
        long total = this.buffers[this.readIndex].position() - this.readPosition;
        for (int i = this.readIndex + 1; i <= this.writeIndex; ++i) {
            total += (long)this.buffers[i].position();
        }
        return total;
    }

    public int remaining(int limit) {
        int total = this.buffers[this.readIndex].position() - this.readPosition;
        if (total >= limit) {
            return limit;
        }
        for (int i = this.readIndex + 1; i <= this.writeIndex; ++i) {
            if ((total += this.buffers[i].position()) < limit) continue;
            return limit;
        }
        return total;
    }

    public long skip(long bytes) {
        long skipped = 0L;
        while (bytes > 0L) {
            if (this.readIndex >= this.writeIndex && this.buffers[this.readIndex].position() == this.readPosition) {
                if (this.writeIndex <= 0) break;
                this.buffers[0] = this.buffers[this.writeIndex];
                this.buffers[this.writeIndex] = null;
                this.writeIndex = 0;
                this.readIndex = 0;
                ((Buffer)this.buffers[0]).clear();
                this.readPosition = 0;
                break;
            }
            int remaining = this.buffers[this.readIndex].position() - this.readPosition;
            if ((long)remaining > bytes) {
                this.readPosition += (int)bytes;
                skipped += bytes;
                break;
            }
            skipped += (long)remaining;
            bytes -= (long)remaining;
            if (this.readIndex < this.writeIndex) {
                this.buffers[this.readIndex++] = null;
                this.readPosition = 0;
                continue;
            }
            assert (this.readIndex == this.writeIndex);
            ((Buffer)this.buffers[this.readIndex]).clear();
            this.readPosition = 0;
        }
        return skipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peek(ByteBuffer dst) {
        int readPosition = this.readPosition;
        for (int readIndex = this.readIndex; dst.hasRemaining() && (readIndex < this.writeIndex || this.buffers[readIndex].position() != readPosition); ++readIndex) {
            int p = this.buffers[readIndex].position();
            int l = this.buffers[readIndex].limit();
            try {
                ((Buffer)this.buffers[readIndex]).position(readPosition);
                ((Buffer)this.buffers[readIndex]).limit(p);
                if (this.buffers[readIndex].remaining() > dst.remaining()) {
                    ((Buffer)this.buffers[readIndex]).limit(dst.remaining());
                    dst.put(this.buffers[readIndex]);
                    break;
                }
                dst.put(this.buffers[readIndex]);
            }
            finally {
                ((Buffer)this.buffers[readIndex]).limit(l);
                ((Buffer)this.buffers[readIndex]).position(p);
            }
            readPosition = 0;
        }
    }

    public void get(ByteBuffer dst) {
        while (dst.hasRemaining()) {
            if (this.readIndex >= this.writeIndex && this.buffers[this.readIndex].position() == this.readPosition) {
                if (this.writeIndex <= 0) break;
                this.buffers[0] = this.buffers[this.writeIndex];
                this.buffers[this.writeIndex] = null;
                this.writeIndex = 0;
                this.readIndex = 0;
                break;
            }
            ((Buffer)this.buffers[this.readIndex]).flip();
            if (this.buffers[this.readIndex].remaining() - this.readPosition > dst.remaining()) {
                int limit = this.buffers[this.readIndex].limit();
                ((Buffer)this.buffers[this.readIndex]).limit(this.readPosition + dst.remaining());
                ((Buffer)this.buffers[this.readIndex]).position(this.readPosition);
                dst.put(this.buffers[this.readIndex]);
                this.readPosition = this.buffers[this.readIndex].position();
                ((Buffer)this.buffers[this.readIndex]).limit(this.buffers[this.readIndex].capacity());
                ((Buffer)this.buffers[this.readIndex]).position(limit);
                break;
            }
            ((Buffer)this.buffers[this.readIndex]).position(this.readPosition);
            dst.put(this.buffers[this.readIndex]);
            this.readPosition = 0;
            if (this.readIndex < this.writeIndex) {
                this.buffers[this.readIndex++] = null;
                continue;
            }
            assert (this.readIndex == this.writeIndex);
            ((Buffer)this.buffers[this.readIndex]).clear();
        }
    }

    public int get(byte[] dst, int offset, int len) {
        int read = 0;
        while (len > 0) {
            if (this.readIndex >= this.writeIndex && this.buffers[this.readIndex].position() == this.readPosition) {
                if (this.writeIndex <= 0) break;
                this.buffers[0] = this.buffers[this.writeIndex];
                this.buffers[this.writeIndex] = null;
                this.writeIndex = 0;
                this.readIndex = 0;
                break;
            }
            ((Buffer)this.buffers[this.readIndex]).flip();
            ((Buffer)this.buffers[this.readIndex]).position(this.readPosition);
            int count = this.buffers[this.readIndex].remaining();
            if (count > len) {
                int limit = this.buffers[this.readIndex].limit();
                this.buffers[this.readIndex].get(dst, offset, len);
                read += len;
                this.readPosition = this.buffers[this.readIndex].position();
                ((Buffer)this.buffers[this.readIndex]).limit(this.buffers[this.readIndex].capacity());
                ((Buffer)this.buffers[this.readIndex]).position(limit);
                return read;
            }
            this.buffers[this.readIndex].get(dst, offset, count);
            offset += count;
            read += count;
            len -= count;
            this.readPosition = 0;
            if (this.readIndex < this.writeIndex) {
                this.buffers[this.readIndex++] = null;
                continue;
            }
            assert (this.readIndex == this.writeIndex);
            ((Buffer)this.buffers[this.readIndex]).clear();
        }
        return read;
    }

    public byte get() {
        int readLimit = this.buffers[this.readIndex].position();
        while (this.readIndex < this.writeIndex && readLimit == this.readPosition) {
            this.buffers[this.readIndex] = null;
            ++this.readIndex;
            this.readPosition = 0;
            readLimit = this.buffers[this.readIndex].position();
        }
        if (this.readPosition < readLimit) {
            return this.buffers[this.readIndex].get(this.readPosition++);
        }
        throw new BufferUnderflowException();
    }

    public void unget(ByteBuffer src) {
        if (!src.hasRemaining()) {
            return;
        }
        if (this.readPosition >= src.remaining()) {
            int l = this.buffers[this.readIndex].limit();
            int p = this.buffers[this.readIndex].position();
            ((Buffer)this.buffers[this.readIndex]).limit(this.readPosition);
            this.readPosition -= src.remaining();
            ((Buffer)this.buffers[this.readIndex]).position(this.readPosition);
            this.buffers[this.readIndex].put(src);
            ((Buffer)this.buffers[this.readIndex]).limit(l);
            ((Buffer)this.buffers[this.readIndex]).position(p);
            return;
        }
        if (this.readPosition > 0) {
            ((Buffer)this.buffers[this.readIndex]).flip();
            ((Buffer)this.buffers[this.readIndex]).position(this.readPosition);
            this.buffers[this.readIndex].compact();
            this.readPosition = 0;
        }
        ByteBuffer[] inject = new ByteBuffer[src.remaining() / this.bufferSize + 1];
        int injectIndex = 0;
        while (src.hasRemaining()) {
            if (src.remaining() > this.bufferSize) {
                int limit = src.limit();
                ((Buffer)src).limit(src.position() + this.bufferSize);
                inject[injectIndex++] = this.newByteBuffer().put(src);
                ((Buffer)src).limit(limit);
                continue;
            }
            inject[injectIndex++] = this.newByteBuffer().put(src);
        }
        if (this.readIndex < injectIndex) {
            int injectCount = injectIndex - this.readIndex;
            while (this.writeIndex + injectCount >= this.buffers.length) {
                this.buffers = Arrays.copyOf(this.buffers, this.buffers.length * 2);
                this.shrinkCount = 0;
            }
            System.arraycopy(this.buffers, this.readIndex, this.buffers, injectIndex, this.writeIndex - this.readIndex + 1);
            this.writeIndex += injectCount;
            this.readIndex = 0;
            System.arraycopy(inject, 0, this.buffers, this.readIndex, injectIndex);
        } else {
            this.readIndex -= injectIndex;
            System.arraycopy(inject, 0, this.buffers, this.readIndex, injectIndex);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hasRemaining=" + this.hasRemaining() + ",readIndex=" + this.readIndex + ",writeIndex=" + this.writeIndex + ",capacity=" + this.buffers.length + ",bufSize=" + this.bufferSize + "]";
    }

    public byte[] toByteArray() {
        if (this.readIndex == this.writeIndex) {
            if (this.buffers[this.readIndex].position() == this.readPosition) {
                return EMPTY_BYTE_ARRAY;
            }
            ((Buffer)this.buffers[this.readIndex]).flip();
            ((Buffer)this.buffers[this.readIndex]).position(this.readPosition);
            byte[] result = new byte[this.buffers[this.readIndex].remaining()];
            this.buffers[this.readIndex].get(result);
            ((Buffer)this.buffers[this.readIndex]).clear();
            this.readPosition = 0;
            this.writeIndex = 0;
            this.readIndex = 0;
            return result;
        }
        int size = 0;
        for (int index = this.readIndex; index <= this.writeIndex; ++index) {
            size += this.buffers[index].position();
        }
        byte[] result = new byte[size];
        int pos = 0;
        for (int index = this.readIndex; index <= this.writeIndex; ++index) {
            ((Buffer)this.buffers[index]).flip();
            ((Buffer)this.buffers[index]).position(this.readPosition);
            int count = this.buffers[index].remaining();
            this.buffers[index].get(result, pos, count);
            ((Buffer)this.buffers[index]).clear();
            this.readPosition = 0;
            pos += count;
        }
        this.writeIndex = 0;
        this.readIndex = 0;
        return result;
    }
}

