/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

class Closeables {
    private static final Logger LOGGER = Logger.getLogger(Closeables.class.getName());

    Closeables() {
    }

    public static Closeable input(SelectableChannel ch) {
        if (ch instanceof SocketChannel) {
            SocketChannel s = (SocketChannel)ch;
            return () -> {
                try {
                    s.socket().shutdownInput();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to close " + String.valueOf(s), e);
                }
                Closeables.maybeClose(s);
            };
        }
        return ch;
    }

    public static Closeable output(SelectableChannel ch) {
        if (ch instanceof SocketChannel) {
            SocketChannel s = (SocketChannel)ch;
            return () -> {
                try {
                    s.socket().shutdownOutput();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to close " + String.valueOf(s), e);
                }
                Closeables.maybeClose(s);
            };
        }
        return ch;
    }

    private static void maybeClose(SocketChannel sc) throws IOException {
        Socket s = sc.socket();
        if (s.isInputShutdown() && s.isOutputShutdown()) {
            s.close();
            sc.close();
        }
    }
}

