/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import winstone.ConnectorFactory;
import winstone.HostConfiguration;
import winstone.HostGroup;
import winstone.Logger;
import winstone.ShutdownHook;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.CmdLineParser;
import winstone.cmdline.Option;

public class Launcher
implements Runnable {
    static final String HTTP_LISTENER_CLASS = "winstone.HttpConnectorFactory";
    static final String HTTPS_LISTENER_CLASS = "winstone.HttpsConnectorFactory";
    static final String HTTP2_LISTENER_CLASS = "winstone.Http2ConnectorFactory";
    public static final byte SHUTDOWN_TYPE = 48;
    public static final byte RELOAD_TYPE = 52;
    public static final String WINSTONE_PORT_FILE_NAME_PROPERTY = "winstone.portFileName";
    private int CONTROL_TIMEOUT = 2000;
    private static int SHUTDOWN_TIMEOUT = 20000;
    private Thread controlThread;
    public static final WinstoneResourceBundle RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    private int controlPort;
    private HostGroup hostGroup;
    private Map<String, String> args;
    public final Server server;
    private boolean shutdownComplete;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Intentionally overridable")
    public static String USAGE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"}, justification="TODO needs triage")
    public Launcher(Map<String, String> args) throws IOException {
        boolean success = false;
        this.installLogHandler();
        try {
            Logger.log(Level.ALL, RESOURCES, "Launcher.StartupArgs", (Object)("" + args));
            this.args = args;
            this.controlPort = Option.CONTROL_PORT.get(args);
            ArrayList<URL> jars = new ArrayList<URL>();
            String defaultJavaHome = System.getProperty("java.home");
            File javaHome = Option.JAVA_HOME.get(args, new File(defaultJavaHome));
            Logger.log(Level.FINER, RESOURCES, "Launcher.UsingJavaHome", (Object)javaHome.getPath());
            File libFolder = Option.COMMON_LIB_FOLDER.get(args, new File("lib"));
            if (libFolder.exists() && libFolder.isDirectory()) {
                Logger.log(Level.FINER, RESOURCES, "Launcher.UsingCommonLib", (Object)libFolder.getCanonicalPath());
                File[] children = libFolder.listFiles();
                if (children != null) {
                    for (File aChildren : children) {
                        if (!aChildren.getName().endsWith(".jar") && !aChildren.getName().endsWith(".zip")) continue;
                        jars.add(aChildren.toURI().toURL());
                        Logger.log(Level.FINER, RESOURCES, "Launcher.AddedCommonLibJar", (Object)aChildren.getName());
                    }
                }
            } else {
                Logger.log(Level.FINER, RESOURCES, "Launcher.NoCommonLib");
            }
            URLClassLoader commonLibCL = new URLClassLoader(jars.toArray(new URL[0]), this.getClass().getClassLoader());
            Logger.log(Level.ALL, RESOURCES, "Launcher.CLClassLoader", (Object)commonLibCL.toString());
            int qtpMaxThread = Option.QTP_MAXTHREADS.get(args);
            QueuedThreadPool queuedThreadPool = qtpMaxThread > 0 ? new QueuedThreadPool(qtpMaxThread) : new QueuedThreadPool();
            queuedThreadPool.setName("Jetty (winstone)");
            this.server = new Server(queuedThreadPool);
            LowResourceMonitor lowResourceMonitor = new LowResourceMonitor(this.server);
            lowResourceMonitor.setMonitorThreads(true);
            this.server.addBean(lowResourceMonitor);
            this.hostGroup = new HostGroup(this.server, commonLibCL, args);
            ArrayList<Connector> connectors = new ArrayList<Connector>();
            this.spawnListener(HTTP_LISTENER_CLASS, connectors);
            this.spawnListener(HTTPS_LISTENER_CLASS, connectors);
            this.spawnListener(HTTP2_LISTENER_CLASS, connectors);
            lowResourceMonitor.setMonitoredConnectors(connectors);
            if (Option.USE_JMX.get(args)) {
                MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
                this.server.addBean(mbeanContainer);
            }
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger("org.eclipse.jetty.ee9.annotations.AnnotationParser");
            logger.setLevel(Level.SEVERE);
            try {
                this.server.start();
                this.writePortToFileIfNeeded();
            }
            catch (Exception e) {
                throw new IOException("Failed to start Jetty", e);
            }
            this.controlThread = new Thread((Runnable)this, RESOURCES.getString("Launcher.ThreadName", "" + this.controlPort));
            this.controlThread.setDaemon(false);
            this.controlThread.start();
            success = true;
        }
        finally {
            if (!success) {
                this.shutdown();
            }
        }
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
        }
        catch (IllegalStateException x) {
            Logger.logDirectMessage(Level.FINE, null, "Could not add logger shutdown hook", x);
        }
    }

    private synchronized boolean isShutdownComplete() {
        return this.shutdownComplete;
    }

    private void installLogHandler() {
        Handler[] handlers;
        java.util.logging.Logger root = java.util.logging.Logger.getLogger("");
        for (Handler h : handlers = root.getHandlers()) {
            root.removeHandler(h);
        }
        root.addHandler(new LogHandler(this));
        for (Handler h : handlers) {
            root.addHandler(h);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Not applicable, this is called from command line")
    private void writePortToFileIfNeeded() throws IOException {
        String portFileName = System.getProperty(WINSTONE_PORT_FILE_NAME_PROPERTY);
        if (portFileName == null) return;
        Connector[] connectors = this.server.getConnectors();
        if (connectors.length <= 0) throw new IllegalStateException("No connectors found");
        Connector connector = connectors[0];
        if (!(connector instanceof ServerConnector)) throw new IllegalStateException("Only ServerConnector is supported");
        int port = ((ServerConnector)connector).getLocalPort();
        Path portFile = Paths.get(portFileName, new String[0]);
        Path portDir = portFile.getParent();
        if (portDir == null) {
            throw new IllegalArgumentException("Given port file name doesn't have a parent: " + portFileName);
        }
        Files.createDirectories(portDir, new FileAttribute[0]);
        Path fileName = portFile.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("Given port file name doesn't have a name: " + portFileName);
        }
        Path tmpPath = Files.createTempFile(portDir, fileName.toString(), null, new FileAttribute[0]);
        Files.writeString(tmpPath, (CharSequence)Integer.toString(port), StandardCharsets.UTF_8, new OpenOption[0]);
        try {
            Files.move(tmpPath, portFile, StandardCopyOption.ATOMIC_MOVE);
            return;
        }
        catch (AtomicMoveNotSupportedException e) {
            Logger.logDirectMessage(Level.WARNING, null, "Atomic move not supported. Falling back to non-atomic move.", e);
            try {
                Files.move(tmpPath, portFile, StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            catch (IOException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    protected Connector spawnListener(String listenerClassName, List<Connector> connectors) throws IOException {
        try {
            ConnectorFactory connectorFactory = (ConnectorFactory)Class.forName(listenerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Connector connector = connectorFactory.start(this.args, this.server);
            if (connector != null) {
                connectors.add(connector);
            }
            return connector;
        }
        catch (Throwable err) {
            throw new IOException("Failed to start a listener: " + listenerClassName, err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean interrupted = false;
        try {
            ServerSocket controlSocket = null;
            if (this.controlPort > 0) {
                controlSocket = new ServerSocket(this.controlPort);
                controlSocket.setSoTimeout(this.CONTROL_TIMEOUT);
            }
            Logger.log(Level.INFO, RESOURCES, "Launcher.StartupOK", RESOURCES.getString("ServerVersion"), this.controlPort > 0 ? "" + this.controlPort : RESOURCES.getString("Launcher.ControlDisabled"));
            while (!interrupted) {
                Socket accepted = null;
                try {
                    if (controlSocket != null) {
                        accepted = controlSocket.accept();
                        if (accepted == null) continue;
                        this.handleControlRequest(accepted);
                        continue;
                    }
                    Thread.sleep(this.CONTROL_TIMEOUT);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (InterruptedException err) {
                    interrupted = true;
                }
                catch (Throwable err) {
                    Logger.log(Level.SEVERE, RESOURCES, "Launcher.ShutdownError", err);
                }
                finally {
                    if (accepted != null) {
                        try {
                            accepted.close();
                        }
                        catch (IOException err) {}
                    }
                    if (!Thread.interrupted()) continue;
                    interrupted = true;
                }
            }
            if (controlSocket != null) {
                controlSocket.close();
            }
        }
        catch (Throwable err) {
            Logger.log(Level.SEVERE, RESOURCES, "Launcher.ShutdownError", err);
        }
        Logger.log(Level.INFO, RESOURCES, "Launcher.ControlThreadShutdownOK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleControlRequest(Socket csAccepted) throws IOException {
        InputStream inSocket = null;
        ObjectInputStream inControl = null;
        try {
            inSocket = csAccepted.getInputStream();
            int reqType = inSocket.read();
            if ((byte)reqType == 48) {
                Logger.log(Level.INFO, RESOURCES, "Launcher.ShutdownRequestReceived");
                this.shutdown();
            } else if ((byte)reqType == 52) {
                inControl = new ObjectInputStream(inSocket);
                String host = inControl.readUTF();
                String prefix = inControl.readUTF();
                Logger.log(Level.INFO, RESOURCES, "Launcher.ReloadRequestReceived", (Object)(host + prefix));
                HostConfiguration hostConfig = this.hostGroup.getHostByName(host);
                hostConfig.reloadWebApp(prefix);
            }
        }
        finally {
            if (inControl != null) {
                try {
                    inControl.close();
                }
                catch (IOException iOException) {}
            }
            if (inSocket != null) {
                try {
                    inSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            Logger.log(Level.INFO, RESOURCES, "Launcher.FailedShutdown", e);
        }
        Launcher launcher = this;
        synchronized (launcher) {
            this.shutdownComplete = true;
            this.notifyAll();
        }
        if (this.controlThread != null) {
            this.controlThread.interrupt();
        }
        Thread.yield();
        Logger.log(Level.INFO, RESOURCES, "Launcher.ShutdownOK");
    }

    public boolean isRunning() {
        return this.controlThread != null && this.controlThread.isAlive();
    }

    public static void main(String[] argv) throws IOException {
        Map<String, String> args = Launcher.getArgsFromCommandLine(argv);
        if (System.getProperty("java.util.logging.config.file") == null) {
            for (Handler h : java.util.logging.Logger.getLogger("").getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                ((ConsoleHandler)h).setFormatter(new SupportLogFormatter());
            }
        }
        if (Option.USAGE.isIn(args) || Option.HELP.isIn(args)) {
            Launcher.printUsage();
            return;
        }
        Launcher.deployEmbeddedWarfile(args);
        if (!Option.WEBROOT.isIn(args) && !Option.WARFILE.isIn(args)) {
            Launcher.printUsage();
            return;
        }
        try {
            new Launcher(args);
        }
        catch (Throwable err) {
            err.printStackTrace();
            Logger.log(Level.SEVERE, RESOURCES, "Launcher.ContainerStartupError", err);
            System.exit(1);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="TODO needs triage")
    public static Map<String, String> getArgsFromCommandLine(String[] argv) throws IOException {
        File webapp;
        Map<String, String> args = new CmdLineParser(Option.all(Option.class)).parse(argv, "nonSwitch");
        String firstNonSwitchArgument = args.get("nonSwitch");
        args.remove("nonSwitch");
        if (firstNonSwitchArgument != null && (webapp = new File(firstNonSwitchArgument)).exists()) {
            if (webapp.isDirectory()) {
                args.put(Option.WEBROOT.name, firstNonSwitchArgument);
            } else if (webapp.isFile()) {
                args.put(Option.WARFILE.name, firstNonSwitchArgument);
            }
        }
        return args;
    }

    protected static void deployEmbeddedWarfile(Map<String, String> args) throws IOException {
        String embeddedWarfileName = RESOURCES.getString("Launcher.EmbeddedWarFile");
        try (InputStream embeddedWarfile = Launcher.class.getResourceAsStream(embeddedWarfileName);){
            if (embeddedWarfile == null) {
                return;
            }
            File tempWarfile = File.createTempFile("embedded", ".war").getAbsoluteFile();
            File parentTempWarFile = tempWarfile.getParentFile();
            try {
                Files.createDirectories(parentTempWarFile.toPath(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                Logger.logDirectMessage(Level.WARNING, null, "Failed to mkdirs " + parentTempWarFile.getAbsolutePath(), ex);
            }
            tempWarfile.deleteOnExit();
            String embeddedWebroot = RESOURCES.getString("Launcher.EmbeddedWebroot");
            File tempWebroot = new File(tempWarfile.getParentFile(), embeddedWebroot);
            try {
                Files.createDirectories(tempWebroot.toPath(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                Logger.logDirectMessage(Level.WARNING, null, "Failed to mkdirs " + tempWebroot.getAbsolutePath(), ex);
            }
            Logger.log(Level.FINER, RESOURCES, "Launcher.CopyingEmbeddedWarfile", (Object)tempWarfile.getAbsolutePath());
            try (FileOutputStream out = new FileOutputStream(tempWarfile, true);){
                int read;
                byte[] buffer = new byte[2048];
                while ((read = embeddedWarfile.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                }
            }
            Option.WARFILE.put(args, tempWarfile.getAbsolutePath());
            Option.WARFILE.put(args, tempWebroot.getAbsolutePath());
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="false positive, args come from command line")
    public static void initLogger(Map<String, String> args) throws IOException {
        int logLevel = Option.DEBUG.get(args);
        boolean showThrowingThread = Option.LOG_THROWING_THREAD.get(args);
        if (args.get("logfile") != null) {
            Path logPath;
            try {
                logPath = Paths.get(args.get("logfile"), new String[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            OutputStream outputStream = Files.newOutputStream(logPath, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            PrintStream printStream = new PrintStream(outputStream, false, Charset.defaultCharset());
            System.setOut(printStream);
            System.setErr(printStream);
        }
        Logger.init(Level.parse(String.valueOf(logLevel)), showThrowingThread);
    }

    protected static void printUsage() {
        Object usage = USAGE;
        String header = RESOURCES.getString("Launcher.UsageInstructions.Header", RESOURCES.getString("ServerVersion"));
        String options = RESOURCES.getString("Launcher.UsageInstructions.Options");
        String footer = RESOURCES.getString("Launcher.UsageInstructions.Options");
        usage = usage == null ? header + options + footer : ((String)usage).replace("{HEADER}", header).replace("{OPTIONS}", options).replace("{FOOTER}", footer);
        System.out.println((String)usage);
    }

    private static class LogHandler
    extends Handler {
        @NonNull
        private final Launcher launcher;

        LogHandler(@NonNull Launcher launcher) {
            this.launcher = launcher;
        }

        @Override
        public void publish(LogRecord record) {
        }

        @Override
        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                Launcher launcher = this.launcher;
                synchronized (launcher) {
                    long timeoutMillis;
                    long target = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + (long)SHUTDOWN_TIMEOUT;
                    while (!this.launcher.isShutdownComplete() && (timeoutMillis = target - TimeUnit.NANOSECONDS.toMillis(System.nanoTime())) > 0L) {
                        this.launcher.wait(timeoutMillis);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

