/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ui.symbol;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.logging.Logger;

public final class SymbolRequest {
    private static final Logger LOGGER = Logger.getLogger(SymbolRequest.class.getName());
    @NonNull
    private final String name;
    @CheckForNull
    private final String title;
    @CheckForNull
    private final String tooltip;
    @CheckForNull
    private final String htmlTooltip;
    @CheckForNull
    private final String classes;
    @CheckForNull
    private final String pluginName;
    @CheckForNull
    private final String id;

    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getTitle() {
        return this.title;
    }

    @CheckForNull
    public String getTooltip() {
        return this.tooltip;
    }

    @CheckForNull
    public String getHtmlTooltip() {
        return this.htmlTooltip;
    }

    @CheckForNull
    public String getClasses() {
        return this.classes;
    }

    @CheckForNull
    public String getPluginName() {
        return this.pluginName;
    }

    @CheckForNull
    public String getId() {
        return this.id;
    }

    private SymbolRequest(@NonNull String name, @CheckForNull String title, @CheckForNull String tooltip, @CheckForNull String htmlTooltip, @CheckForNull String classes, @CheckForNull String pluginName, @CheckForNull String id) {
        this.name = name;
        this.title = title;
        this.tooltip = tooltip;
        this.htmlTooltip = htmlTooltip;
        this.classes = classes;
        this.pluginName = pluginName;
        this.id = id;
    }

    public static class Builder {
        @CheckForNull
        private String name;
        @CheckForNull
        private String title;
        @CheckForNull
        private String tooltip;
        @CheckForNull
        private String htmlTooltip;
        @CheckForNull
        private String classes;
        @CheckForNull
        private String pluginName;
        @CheckForNull
        private String id;
        @CheckForNull
        private String raw;

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public Builder withName(@NonNull String name) {
            this.name = name;
            return this;
        }

        @CheckForNull
        public String getTitle() {
            return this.title;
        }

        public Builder withTitle(@CheckForNull String title) {
            this.title = title;
            return this;
        }

        @CheckForNull
        public String getTooltip() {
            return this.tooltip;
        }

        public Builder withTooltip(@CheckForNull String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        @CheckForNull
        public String getHtmlTooltip() {
            return this.htmlTooltip;
        }

        public Builder withHtmlTooltip(@CheckForNull String htmlTooltip) {
            this.htmlTooltip = htmlTooltip;
            return this;
        }

        @CheckForNull
        public String getClasses() {
            return this.classes;
        }

        public Builder withClasses(@CheckForNull String classes) {
            this.classes = classes;
            return this;
        }

        @CheckForNull
        public String getPluginName() {
            return this.pluginName;
        }

        public Builder withPluginName(@CheckForNull String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        @CheckForNull
        public String getId() {
            return this.id;
        }

        public Builder withId(@CheckForNull String id) {
            this.id = id;
            return this;
        }

        @CheckForNull
        public String getRaw() {
            return this.raw;
        }

        public Builder withRaw(@CheckForNull String raw) {
            this.raw = raw;
            return this;
        }

        @NonNull
        public SymbolRequest build() {
            if (this.name == null && this.pluginName == null && this.raw != null) {
                this.parseRaw(this.raw);
                LOGGER.fine(() -> "\"" + this.raw + "\" parsed to name: " + this.name + " and pluginName: " + this.pluginName);
            }
            if (this.name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            return new SymbolRequest(this.name, this.title, this.tooltip, this.htmlTooltip, this.classes, this.pluginName, this.id);
        }

        private void parseRaw(@NonNull String raw) {
            String[] s = raw.split(" ");
            if (s.length <= 2) {
                for (String element : s) {
                    if (element.startsWith("symbol-")) {
                        this.name = element.substring("symbol-".length());
                    }
                    if (element.startsWith("plugin-")) {
                        this.pluginName = element.substring("plugin-".length());
                    }
                    if (this.name == null || this.pluginName == null) {
                        continue;
                    }
                    break;
                }
            } else {
                throw new IllegalArgumentException("raw must be in the format \"symbol-<name> plugin-<pluginName>\"");
            }
        }
    }
}

