/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Queue;
import java.util.Calendar;
import java.util.Collections;
import jenkins.security.QueueItemAuthenticatorDescriptor;
import org.acegisecurity.Authentication;

public abstract class QueueItemAuthenticator
implements Describable<QueueItemAuthenticator>,
ExtensionPoint {
    @CheckForNull
    public org.springframework.security.core.Authentication authenticate2(Queue.Item item) {
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate2", Queue.Task.class)) {
            return this.authenticate2(item.task);
        }
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate", Queue.Task.class)) {
            Authentication a = this.authenticate(item.task);
            return a != null ? a.toSpring() : null;
        }
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate", Queue.Item.class)) {
            Authentication a = this.authenticate(item);
            return a != null ? a.toSpring() : null;
        }
        throw new AbstractMethodError("you must override at least one of the QueueItemAuthenticator.authenticate2 methods");
    }

    @CheckForNull
    public org.springframework.security.core.Authentication authenticate2(Queue.Task task) {
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate2", Queue.Item.class)) {
            return this.authenticate2(new Queue.WaitingItem(Calendar.getInstance(), task, Collections.emptyList()));
        }
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate", Queue.Item.class)) {
            Authentication a = this.authenticate(new Queue.WaitingItem(Calendar.getInstance(), task, Collections.emptyList()));
            return a != null ? a.toSpring() : null;
        }
        if (Util.isOverridden(QueueItemAuthenticator.class, this.getClass(), "authenticate", Queue.Task.class)) {
            Authentication a = this.authenticate(task);
            return a != null ? a.toSpring() : null;
        }
        throw new AbstractMethodError("you must override at least one of the QueueItemAuthenticator.authenticate2 methods");
    }

    @Deprecated
    @CheckForNull
    public Authentication authenticate(Queue.Item item) {
        org.springframework.security.core.Authentication a = this.authenticate2(item);
        return a != null ? Authentication.fromSpring(a) : null;
    }

    @Deprecated
    @CheckForNull
    public Authentication authenticate(Queue.Task task) {
        org.springframework.security.core.Authentication a = this.authenticate2(task);
        return a != null ? Authentication.fromSpring(a) : null;
    }

    public QueueItemAuthenticatorDescriptor getDescriptor() {
        return (QueueItemAuthenticatorDescriptor)Describable.super.getDescriptor();
    }
}

