/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AperiodicWork;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Queue;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import jenkins.model.GlobalComputerRetentionCheckIntervalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"computerRetention"})
public class ComputerRetentionWork
extends AperiodicWork {
    private final Map<Computer, Long> nextCheck = new WeakHashMap<Computer, Long>();

    @Override
    public long getRecurrencePeriod() {
        return (long)ExtensionList.lookupSingleton(GlobalComputerRetentionCheckIntervalConfiguration.class).getComputerRetentionCheckInterval() * 1000L;
    }

    @Override
    public AperiodicWork getNewInstance() {
        return this;
    }

    @Override
    protected void doAperiodicRun() {
        final long startRun = System.currentTimeMillis();
        for (final Computer c : Jenkins.get().getComputers()) {
            Queue.withLock(new Runnable(){

                @Override
                public void run() {
                    Node n = c.getNode();
                    if (n != null && n.isHoldOffLaunchUntilSave()) {
                        return;
                    }
                    if (!ComputerRetentionWork.this.nextCheck.containsKey(c) || startRun > ComputerRetentionWork.this.nextCheck.get(c)) {
                        long waitInMins = Math.max(0L, Math.min(60L, c.getRetentionStrategy().check(c)));
                        ComputerRetentionWork.this.nextCheck.put(c, startRun + TimeUnit.MINUTES.toMillis(waitInMins));
                    }
                }
            });
        }
    }
}

