/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

final class Timeline {
    private final TreeMap<Long, int[]> data = new TreeMap();

    Timeline() {
    }

    private int at(long t) {
        SortedMap<Long, int[]> head = this.data.subMap(t, Long.MAX_VALUE);
        if (head.isEmpty()) {
            return 0;
        }
        return this.data.get(head.firstKey())[0];
    }

    private Long next(long t) {
        SortedMap<Long, int[]> x = this.data.tailMap(t + 1L);
        return x.isEmpty() ? null : x.firstKey();
    }

    private void splitAt(long t) {
        if (this.data.containsKey(t)) {
            return;
        }
        SortedMap<Long, int[]> head = this.data.headMap(t);
        int v = head.isEmpty() ? 0 : this.data.get(head.lastKey())[0];
        this.data.put(t, new int[]{v});
    }

    int insert(long start, long end, int n) {
        this.splitAt(start);
        this.splitAt(end);
        int peak = 0;
        for (Map.Entry<Long, int[]> e : this.data.tailMap(start).headMap(end).entrySet()) {
            int[] nArray = e.getValue();
            int n2 = nArray[0] + n;
            nArray[0] = n2;
            peak = Math.max(peak, n2);
        }
        return peak;
    }

    Long fit(long start, long duration, int n) {
        block0: while (true) {
            long t = start;
            while (t - start < duration) {
                Long nxt;
                if (this.at(t) > n) {
                    nxt = this.next(t);
                    if (nxt == null) {
                        return null;
                    }
                    start = nxt;
                    continue block0;
                }
                nxt = this.next(t);
                if (nxt == null) {
                    t = Long.MAX_VALUE;
                    continue;
                }
                t = nxt;
            }
            break;
        }
        return start;
    }
}

