/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Descriptor;
import hudson.model.Messages;
import hudson.model.ModifiableViewGroup;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.ViewGroupMixIn;
import hudson.model.userproperty.UserPropertyCategory;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.views.DefaultViewsTabBar;
import hudson.views.MyViewsTabBar;
import hudson.views.ViewsTabBar;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class MyViewsProperty
extends UserProperty
implements ModifiableViewGroup,
Action,
StaplerFallback,
StaplerProxy {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(MyViewsProperty.class.getName() + ".skipPermissionCheck");
    @CheckForNull
    private String primaryViewName;
    private ViewsTabBar viewsTabBar = new DefaultViewsTabBar();
    private CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList();
    private transient ViewGroupMixIn viewGroupMixIn;

    @DataBoundConstructor
    public MyViewsProperty(@CheckForNull String primaryViewName) {
        this.primaryViewName = primaryViewName;
        this.readResolve();
    }

    private MyViewsProperty() {
        this(null);
    }

    @Restricted(value={NoExternalUse.class})
    public Object readResolve() {
        if (this.views == null) {
            this.views = new CopyOnWriteArrayList();
        }
        if (this.views.isEmpty()) {
            this.views.add(new AllView("all", this));
        }
        if (this.primaryViewName != null) {
            this.primaryViewName = AllView.migrateLegacyPrimaryAllViewLocalizedName(this.views, this.primaryViewName);
        }
        this.viewGroupMixIn = new ViewGroupMixIn(this){

            @Override
            protected List<View> views() {
                return MyViewsProperty.this.views;
            }

            @Override
            protected String primaryView() {
                return MyViewsProperty.this.primaryViewName;
            }

            @Override
            protected void primaryView(String name) {
                MyViewsProperty.this.primaryViewName = name;
            }
        };
        if (this.viewsTabBar == null) {
            this.viewsTabBar = new DefaultViewsTabBar();
        }
        return this;
    }

    @CheckForNull
    public String getPrimaryViewName() {
        return this.primaryViewName;
    }

    public void setPrimaryViewName(@CheckForNull String primaryViewName) {
        this.primaryViewName = primaryViewName;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public String getUrl() {
        return this.user.getUrl() + "/my-views/";
    }

    @Override
    public void save() throws IOException {
        if (this.user != null) {
            this.user.save();
        }
    }

    @Override
    public Collection<View> getViews() {
        return this.viewGroupMixIn.getViews();
    }

    @Override
    public View getView(String name) {
        return this.viewGroupMixIn.getView(name);
    }

    @Override
    public boolean canDelete(View view) {
        return this.viewGroupMixIn.canDelete(view);
    }

    @Override
    public void deleteView(View view) throws IOException {
        this.viewGroupMixIn.deleteView(view);
    }

    @Override
    public void onViewRenamed(View view, String oldName, String newName) {
        this.viewGroupMixIn.onViewRenamed(view, oldName, newName);
    }

    @Override
    public void addView(View view) throws IOException {
        this.viewGroupMixIn.addView(view);
    }

    @Override
    public View getPrimaryView() {
        return this.viewGroupMixIn.getPrimaryView();
    }

    public HttpResponse doIndex() {
        return new HttpRedirect("view/" + Util.rawEncode(this.getPrimaryView().getViewName()) + "/");
    }

    @POST
    public synchronized void doCreateView(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, ParseException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create(req, rsp, (ViewGroup)this));
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value, @QueryParameter boolean exists) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty(value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (exists) {
            return this.getView(view) != null ? FormValidation.ok() : FormValidation.error(Messages.MyViewsProperty_ViewExistsCheck_NotExist(view));
        }
        return this.getView(view) == null ? FormValidation.ok() : FormValidation.error(Messages.MyViewsProperty_ViewExistsCheck_AlreadyExists(view));
    }

    @Override
    public ACL getACL() {
        return this.user.getACL();
    }

    @Override
    public String getDisplayName() {
        return Messages.MyViewsProperty_DisplayName();
    }

    @Override
    public String getIconFileName() {
        if (SKIP_PERMISSION_CHECK || this.getACL().hasPermission(Jenkins.ADMINISTER)) {
            return "symbol-browsers";
        }
        return null;
    }

    @Override
    public String getUrlName() {
        return "my-views";
    }

    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            this.checkPermission(Jenkins.ADMINISTER);
        }
        return this;
    }

    @Override
    public UserProperty reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        req.bindJSON((Object)this, form);
        return this;
    }

    @Override
    public ViewsTabBar getViewsTabBar() {
        return this.viewsTabBar;
    }

    public void setViewsTabBar(ViewsTabBar viewsTabBar) {
        this.viewsTabBar = viewsTabBar;
    }

    @Override
    public List<Action> getViewActions() {
        return Collections.emptyList();
    }

    public Object getStaplerFallback() {
        return this.getPrimaryView();
    }

    public MyViewsTabBar getMyViewsTabBar() {
        return Jenkins.get().getMyViewsTabBar();
    }

    @Symbol(value={"myView"})
    public static class GlobalAction
    implements RootAction {
        @Override
        public String getDisplayName() {
            return Messages.MyViewsProperty_GlobalAction_DisplayName();
        }

        @Override
        public String getIconFileName() {
            if (User.current() == null) {
                return null;
            }
            return "symbol-browsers";
        }

        @Override
        public String getUrlName() {
            return "/me/my-views";
        }
    }

    @Extension
    @Symbol(value={"myView"})
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.MyViewsProperty_DisplayName();
        }

        @Override
        public UserProperty newInstance(User user) {
            return new MyViewsProperty();
        }

        @Override
        @NonNull
        public UserPropertyCategory getUserPropertyCategory() {
            return UserPropertyCategory.get(UserPropertyCategory.Preferences.class);
        }

        @POST
        public ListBoxModel doFillPrimaryViewNameItems(@AncestorInPath User user) throws IOException {
            ListBoxModel items = new ListBoxModel();
            User user2 = user = user == null ? User.current() : user;
            if (user != null) {
                MyViewsProperty property = user.getProperty(MyViewsProperty.class);
                if (property == null) {
                    property = new MyViewsProperty();
                    property.readResolve();
                    user.addProperty(property);
                }
                for (View view : property.views) {
                    items.add(new ListBoxModel.Option(view.getDisplayName(), view.getViewName(), view == property.getPrimaryView()));
                }
            }
            return items;
        }
    }
}

