/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.util.XStream2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class Cause {
    @Exported(visibility=3)
    public abstract String getShortDescription();

    public void onAddedTo(@NonNull Run build) {
        if (build instanceof AbstractBuild) {
            this.onAddedTo((AbstractBuild)build);
        }
    }

    @Deprecated
    public void onAddedTo(AbstractBuild build) {
        if (Util.isOverridden(Cause.class, this.getClass(), "onAddedTo", Run.class)) {
            this.onAddedTo((Run)build);
        }
    }

    public void onLoad(@NonNull Run<?, ?> build) {
        if (build instanceof AbstractBuild) {
            this.onLoad((AbstractBuild)build);
        }
    }

    void onLoad(@NonNull Job<?, ?> job, int buildNumber) {
        Object build = job.getBuildByNumber(buildNumber);
        if (build != null) {
            this.onLoad((Run<?, ?>)build);
        }
    }

    @Deprecated
    public void onLoad(AbstractBuild<?, ?> build) {
        if (Util.isOverridden(Cause.class, this.getClass(), "onLoad", Run.class)) {
            this.onLoad((Run<?, ?>)build);
        }
    }

    public void print(TaskListener listener) {
        listener.getLogger().println(this.getShortDescription());
    }

    public static class RemoteCause
    extends Cause {
        private String addr;
        private String note;

        public RemoteCause(String host, String note) {
            this.addr = host;
            this.note = note;
        }

        @Override
        public String getShortDescription() {
            if (this.note != null) {
                return Messages.Cause_RemoteCause_ShortDescriptionWithNote(this.addr, this.note);
            }
            return Messages.Cause_RemoteCause_ShortDescription(this.addr);
        }

        @Exported(visibility=3)
        public String getAddr() {
            return this.addr;
        }

        @Exported(visibility=3)
        public String getNote() {
            return this.note;
        }

        public boolean equals(Object o) {
            return o instanceof RemoteCause && Objects.equals(this.addr, ((RemoteCause)o).addr) && Objects.equals(this.note, ((RemoteCause)o).note);
        }

        public int hashCode() {
            return Objects.hash(this.addr, this.note);
        }
    }

    public static class UserIdCause
    extends Cause {
        @CheckForNull
        private String userId;

        public UserIdCause() {
            User user = User.current();
            this.userId = user == null ? null : user.getId();
        }

        public UserIdCause(@CheckForNull String userId) {
            this.userId = userId;
        }

        @Exported(visibility=3)
        @CheckForNull
        public String getUserId() {
            return this.userId;
        }

        @NonNull
        private String getUserIdOrUnknown() {
            return this.userId != null ? this.userId : User.getUnknown().getId();
        }

        @Exported(visibility=3)
        public String getUserName() {
            User user = this.userId == null ? null : User.getById(this.userId, false);
            return user == null ? "anonymous" : user.getDisplayName();
        }

        @Restricted(value={DoNotUse.class})
        @CheckForNull
        public String getUserUrl() {
            User user = this.userId == null ? null : User.getById(this.userId, false);
            return user != null ? user.getUrl() : null;
        }

        @Override
        public String getShortDescription() {
            return Messages.Cause_UserIdCause_ShortDescription(this.getUserName());
        }

        @Override
        public void print(TaskListener listener) {
            User user;
            User user2 = user = this.getUserId() == null ? null : User.getById(this.getUserId(), false);
            if (user != null) {
                listener.getLogger().println(Messages.Cause_UserIdCause_ShortDescription(ModelHyperlinkNote.encodeTo(user)));
            } else {
                listener.getLogger().println(Messages.Cause_UserIdCause_ShortDescription("unknown or anonymous"));
            }
        }

        public boolean equals(Object o) {
            return o instanceof UserIdCause && Objects.equals(this.userId, ((UserIdCause)o).userId);
        }

        public int hashCode() {
            return Objects.hash(this.userId);
        }
    }

    @Deprecated
    public static class UserCause
    extends Cause {
        private String authenticationName = Jenkins.getAuthentication2().getName();

        @Exported(visibility=3)
        public String getUserName() {
            User user = User.getById(this.authenticationName, false);
            return user != null ? user.getDisplayName() : this.authenticationName;
        }

        @Override
        public String getShortDescription() {
            return Messages.Cause_UserCause_ShortDescription(this.authenticationName);
        }

        public boolean equals(Object o) {
            return o instanceof UserCause && Arrays.equals(new Object[]{this.authenticationName}, new Object[]{((UserCause)o).authenticationName});
        }

        public int hashCode() {
            return 295 + (this.authenticationName != null ? this.authenticationName.hashCode() : 0);
        }
    }

    public static class UpstreamCause
    extends Cause {
        private static final int MAX_DEPTH = 10;
        private static final int MAX_LEAF = 25;
        private String upstreamProject;
        private String upstreamUrl;
        private int upstreamBuild;
        @Deprecated
        private transient Cause upstreamCause;
        @NonNull
        private List<Cause> upstreamCauses;

        @Deprecated
        public UpstreamCause(AbstractBuild<?, ?> up) {
            this((Run<?, ?>)up);
        }

        public UpstreamCause(Run<?, ?> up) {
            this.upstreamBuild = up.getNumber();
            this.upstreamProject = ((AbstractItem)up.getParent()).getFullName();
            this.upstreamUrl = ((AbstractItem)up.getParent()).getUrl();
            this.upstreamCauses = new ArrayList<Cause>();
            HashSet<String> traversed = new HashSet<String>();
            for (Cause c : up.getCauses()) {
                if (traversed.size() >= 25) {
                    this.upstreamCauses.add(new DeeplyNestedUpstreamCause());
                    break;
                }
                this.upstreamCauses.add(this.trim(c, 10, traversed));
            }
        }

        private UpstreamCause(String upstreamProject, int upstreamBuild, String upstreamUrl, @NonNull List<Cause> upstreamCauses) {
            this.upstreamProject = upstreamProject;
            this.upstreamBuild = upstreamBuild;
            this.upstreamUrl = upstreamUrl;
            this.upstreamCauses = upstreamCauses;
        }

        @Override
        public void onLoad(@NonNull Job<?, ?> _job, int _buildNumber) {
            Item i = Jenkins.get().getItemByFullName(this.upstreamProject);
            if (!(i instanceof Job)) {
                return;
            }
            Job j = (Job)i;
            for (Cause c : this.upstreamCauses) {
                c.onLoad(j, this.upstreamBuild);
            }
        }

        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (!(rhs instanceof UpstreamCause)) {
                return false;
            }
            UpstreamCause o = (UpstreamCause)rhs;
            return Objects.equals(this.upstreamBuild, o.upstreamBuild) && Objects.equals(this.upstreamCauses, o.upstreamCauses) && Objects.equals(this.upstreamUrl, o.upstreamUrl) && Objects.equals(this.upstreamProject, o.upstreamProject);
        }

        public int hashCode() {
            return Objects.hash(this.upstreamCauses, this.upstreamBuild, this.upstreamUrl, this.upstreamProject);
        }

        @NonNull
        private Cause trim(@NonNull Cause c, int depth, Set<String> traversed) {
            if (!(c instanceof UpstreamCause)) {
                return c;
            }
            UpstreamCause uc = (UpstreamCause)c;
            ArrayList<Cause> cs = new ArrayList<Cause>();
            if (traversed.add(uc.upstreamUrl + uc.upstreamBuild)) {
                for (Cause c2 : uc.upstreamCauses) {
                    if (depth <= 0 || traversed.size() >= 25) {
                        cs.add(new DeeplyNestedUpstreamCause());
                        break;
                    }
                    cs.add(this.trim(c2, depth - 1, traversed));
                }
            } else {
                traversed.add(uc.upstreamUrl + uc.upstreamBuild + "#" + traversed.size());
            }
            return new UpstreamCause(uc.upstreamProject, uc.upstreamBuild, uc.upstreamUrl, cs);
        }

        public boolean pointsTo(Job<?, ?> j) {
            return j.getFullName().equals(this.upstreamProject);
        }

        public boolean pointsTo(Run<?, ?> r) {
            return r.getNumber() == this.upstreamBuild && this.pointsTo((Job<?, ?>)r.getParent());
        }

        @Exported(visibility=3)
        public String getUpstreamProject() {
            return this.upstreamProject;
        }

        @Exported(visibility=3)
        public int getUpstreamBuild() {
            return this.upstreamBuild;
        }

        @CheckForNull
        public Run<?, ?> getUpstreamRun() {
            Job job = Jenkins.get().getItemByFullName(this.upstreamProject, Job.class);
            return job != null ? (Run<?, ?>)job.getBuildByNumber(this.upstreamBuild) : null;
        }

        @Exported(visibility=3)
        public String getUpstreamUrl() {
            return this.upstreamUrl;
        }

        public List<Cause> getUpstreamCauses() {
            return this.upstreamCauses;
        }

        @Override
        public String getShortDescription() {
            return Messages.Cause_UpstreamCause_ShortDescription(this.upstreamProject, this.upstreamBuild);
        }

        @Override
        public void print(TaskListener listener) {
            this.print(listener, 0);
        }

        private void indent(TaskListener listener, int depth) {
            for (int i = 0; i < depth; ++i) {
                listener.getLogger().print(' ');
            }
        }

        private void print(TaskListener listener, int depth) {
            this.indent(listener, depth);
            listener.getLogger().println(Messages.Cause_UpstreamCause_ShortDescription(ModelHyperlinkNote.encodeTo("/" + this.upstreamUrl, this.upstreamProject), ModelHyperlinkNote.encodeTo("/" + this.upstreamUrl + this.upstreamBuild, Integer.toString(this.upstreamBuild))));
            if (this.upstreamCauses != null && !this.upstreamCauses.isEmpty()) {
                this.indent(listener, depth);
                listener.getLogger().println(Messages.Cause_UpstreamCause_CausedBy());
                for (Cause cause : this.upstreamCauses) {
                    if (cause instanceof UpstreamCause) {
                        ((UpstreamCause)cause).print(listener, depth + 1);
                        continue;
                    }
                    this.indent(listener, depth + 1);
                    cause.print(listener);
                }
            }
        }

        public String toString() {
            return this.upstreamUrl + this.upstreamBuild + String.valueOf(this.upstreamCauses);
        }

        public static class DeeplyNestedUpstreamCause
        extends Cause {
            @Override
            public String getShortDescription() {
                return "(deeply nested causes)";
            }

            public String toString() {
                return "JENKINS-14814";
            }

            @Override
            public void onLoad(@NonNull Job<?, ?> _job, int _buildNumber) {
            }
        }

        public static class ConverterImpl
        extends XStream2.PassthruConverter<UpstreamCause> {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }

            @Override
            protected void callback(UpstreamCause uc, UnmarshallingContext context) {
                if (uc.upstreamCause != null) {
                    uc.upstreamCauses.add(uc.upstreamCause);
                    uc.upstreamCause = null;
                    OldDataMonitor.report(context, "1.288");
                }
            }
        }
    }

    @Deprecated
    public static class LegacyCodeCause
    extends Cause {
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="for backward compatibility")
        private StackTraceElement[] stackTrace = new Exception().getStackTrace();

        @Override
        public String getShortDescription() {
            return Messages.Cause_LegacyCodeCause_ShortDescription();
        }
    }
}

