/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.model.UploadResult;
import com.xpandit.xray.service.impl.delegates.ResponseBodyMessageResolverDelegate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UploadResponseResolverDelegate {
    private static Logger logger = LogManager.getLogger(UploadResponseResolverDelegate.class);
    private static final int TOO_MANY_REQUESTS_STATUS_CODE = 429;
    private ResponseBodyMessageResolverDelegate bodyMessageResolverDelegate = new ResponseBodyMessageResolverDelegate();

    public UploadResult resolveUploadResponse(CloseableHttpResponse closeableHttpResponse) throws IOException {
        String string = "Unable to confirm Result of the upload..... ";
        if (closeableHttpResponse == null) {
            string = string + "null server response";
            throw new XrayClientCoreGenericException(string);
        }
        int n = closeableHttpResponse.getStatusLine().getStatusCode();
        logger.debug("Status Code of Request:" + n);
        if (n == 429) {
            String string2 = this.getRetryAfterMessage(closeableHttpResponse);
            logger.error("429 status code: " + string2);
            return new UploadResult(string2, n, (HttpResponse)closeableHttpResponse);
        }
        if (n != 200 && n != 202) {
            String string3 = this.bodyMessageResolverDelegate.resolveResponseBodyMessage((HttpResponse)closeableHttpResponse);
            String string4 = "Upload Failed! Status:" + n;
            String string5 = "Response:" + string3;
            logger.error(string4);
            logger.error(string5);
            string = string + string4 + " " + string5;
            throw new XrayClientCoreGenericException(string);
        }
        logger.info("Upload OK! Status: " + n);
        String string6 = this.getResponseResult(closeableHttpResponse.getEntity().getContent());
        closeableHttpResponse.close();
        logger.debug("Upload OK! result: " + string6);
        return new UploadResult(string6, n, (HttpResponse)closeableHttpResponse);
    }

    private String getResponseResult(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                string = bufferedReader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
    }

    private String getRetryAfterMessage(CloseableHttpResponse closeableHttpResponse) {
        String string = Optional.ofNullable(closeableHttpResponse.getFirstHeader("Retry-After")).map(NameValuePair::getValue).orElse(null);
        String string2 = "Too many requests, please retry ";
        string2 = StringUtils.isBlank((CharSequence)string) ? string2 + "in a few moments." : (NumberUtils.isParsable((String)string) ? string2 + "after: " + string + " seconds." : string2 + "after: " + string);
        return string2;
    }
}

