/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.model.FileStream;
import com.xpandit.xray.model.UploadResult;
import com.xpandit.xray.service.impl.delegates.HttpCloudRequestProvider;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.service.impl.delegates.HttpServerRequestProvider;
import com.xpandit.xray.service.impl.delegates.UploadResponseResolverDelegate;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestImporterDelegate {
    private static Logger logger = LogManager.getLogger(TestImporterDelegate.class);
    private final HttpRequestProvider httpProvider;

    public TestImporterDelegate(HttpRequestProvider httpRequestProvider) {
        this.httpProvider = httpRequestProvider;
    }

    public UploadResult importFeatures(String string, FileStream fileStream, FileStream fileStream2, FileStream fileStream3) {
        UploadResult uploadResult;
        block13: {
            String string2;
            UploadResponseResolverDelegate uploadResponseResolverDelegate = new UploadResponseResolverDelegate();
            if (string == null) {
                throw new XrayClientCoreGenericException("Project key cannot be null");
            }
            if (fileStream == null) {
                throw new XrayClientCoreGenericException("The fileStream cannot be null");
            }
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.addPart("file", (ContentBody)new InputStreamBody(fileStream.getContent(), fileStream.getMediaType(), fileStream.getFileName()));
            if (fileStream2 != null) {
                multipartEntityBuilder.addPart("testInfo", (ContentBody)new InputStreamBody(fileStream2.getContent(), fileStream2.getMediaType(), fileStream2.getFileName()));
            }
            if (fileStream3 != null) {
                string2 = "preCondInfo";
                if (this.isCloudInstance()) {
                    string2 = "precondInfo";
                }
                multipartEntityBuilder.addPart(string2, (ContentBody)new InputStreamBody(fileStream3.getContent(), fileStream3.getMediaType(), fileStream3.getFileName()));
            }
            string2 = this.httpProvider.doPostRequest(this.getUrl(string), multipartEntityBuilder.build());
            try {
                uploadResult = uploadResponseResolverDelegate.resolveUploadResponse((CloseableHttpResponse)string2);
                if (string2 == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (string2 != null) {
                        try {
                            string2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    logger.error(iOException.getMessage());
                    throw new XrayClientCoreGenericException(iOException);
                }
            }
            string2.close();
        }
        return uploadResult;
    }

    private String getUrl(String string) {
        return this.httpProvider.getBaseUrl() + this.httpProvider.getEndpointImportFeaturesPrefix() + "?projectKey=" + string;
    }

    private boolean isCloudInstance() {
        return this.httpProvider instanceof HttpCloudRequestProvider;
    }

    private boolean isServerInstance() {
        return this.httpProvider instanceof HttpServerRequestProvider;
    }
}

