/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HttpRequestProvider {
    private static Logger logger = LogManager.getLogger(HttpRequestProvider.class);
    private final ProxyBean proxyBean;

    HttpRequestProvider(ProxyBean proxyBean) {
        this.proxyBean = proxyBean;
    }

    public CloseableHttpResponse doGetRequest(String string) throws XrayClientCoreGenericException, IOException {
        CloseableHttpClient closeableHttpClient = this.createHttpClient(string);
        HttpGet httpGet = this.prepareHttpGetHeader(string);
        return closeableHttpClient.execute((HttpUriRequest)httpGet);
    }

    public CloseableHttpResponse doGetRequestNotAuthenticated(String string) throws XrayClientCoreGenericException, IOException {
        CloseableHttpClient closeableHttpClient = this.createHttpClient(string);
        HttpGet httpGet = new HttpGet(string);
        return closeableHttpClient.execute((HttpUriRequest)httpGet);
    }

    public CloseableHttpResponse doPostRequest(String string, HttpEntity httpEntity) throws XrayClientCoreGenericException, IOException {
        CloseableHttpClient closeableHttpClient = this.createHttpClient(string);
        HttpPost httpPost = this.prepareHttpPostHeader(string);
        httpPost.setEntity(httpEntity);
        return closeableHttpClient.execute((HttpUriRequest)httpPost);
    }

    public CloseableHttpClient createHttpClient(String string) throws XrayClientCoreGenericException {
        try {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            this.withSslSocketFactory(httpClientBuilder);
            this.withProxy(httpClientBuilder, string);
            return httpClientBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            logger.error("An error occurred while creating the HTTP client.", (Throwable)generalSecurityException);
            throw new XrayClientCoreGenericException(generalSecurityException.getMessage());
        }
    }

    private void withProxy(HttpClientBuilder httpClientBuilder, String string) {
        if (this.proxyBean != null && this.proxyBean.useProxy(string)) {
            if (this.proxyBean.getHttpHost() != null) {
                DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(this.proxyBean.getHttpHost());
                httpClientBuilder.setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner);
            }
            if (this.proxyBean.getCredentialsProvider() != null) {
                httpClientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE);
                httpClientBuilder.setDefaultCredentialsProvider(this.proxyBean.getCredentialsProvider());
            }
        }
    }

    private void withSslSocketFactory(HttpClientBuilder httpClientBuilder) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext sSLContext = SSLContexts.custom().loadTrustMaterial((x509CertificateArray, string) -> true).build();
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
    }

    public abstract HttpGet prepareHttpGetHeader(String var1);

    public abstract HttpPost prepareHttpPostHeader(String var1);

    public abstract String getBaseUrl();

    public abstract String getEndpointImportPrefix();

    public abstract String getEndpointExportFeaturesPrefix();

    public abstract String getEndpointImportFeaturesPrefix();

    public static class ProxyBean {
        private final HttpHost httpHost;
        private final CredentialsProvider credentialsProvider;
        private final Collection<Pattern> noProxyUrlPatterns;

        public ProxyBean(HttpHost httpHost, CredentialsProvider credentialsProvider) {
            this(httpHost, credentialsProvider, Collections.emptySet());
        }

        public ProxyBean(HttpHost httpHost, CredentialsProvider credentialsProvider, Collection<Pattern> collection) {
            this.httpHost = httpHost;
            this.credentialsProvider = credentialsProvider;
            this.noProxyUrlPatterns = Optional.ofNullable(collection).map(HashSet::new).map(Collections::unmodifiableSet).orElseGet(Collections::emptySet);
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public HttpHost getHttpHost() {
            return this.httpHost;
        }

        public boolean useProxy(String string) {
            return StringUtils.isNotBlank((CharSequence)string) && this.noProxyUrlPatterns.stream().filter(Objects::nonNull).noneMatch(pattern -> pattern.matcher(string).matches());
        }
    }
}

