/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl.delegates;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.model.QueryParameter;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.service.impl.delegates.ResponseBodyMessageResolverDelegate;
import com.xpandit.xray.util.URLConstructor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExporterDelegate {
    private static Logger logger = LogManager.getLogger(ExporterDelegate.class);
    private final HttpRequestProvider httpProvider;

    public ExporterDelegate(HttpRequestProvider httpRequestProvider) {
        this.httpProvider = httpRequestProvider;
    }

    public InputStream downloadFeatures(String string, String string2, String string3) throws XrayClientCoreGenericException {
        String string4 = this.httpProvider.getBaseUrl() + this.httpProvider.getEndpointExportFeaturesPrefix();
        HashMap<QueryParameter, String> hashMap = new HashMap<QueryParameter, String>();
        if (StringUtils.isBlank((CharSequence)string) && StringUtils.isBlank((CharSequence)string2)) {
            logger.error("Unable to download features: Please provide the issue keys or filter ID");
            throw new XrayClientCoreGenericException("Unable to download features: Please provide the issue keys or filter ID");
        }
        hashMap.put(QueryParameter.ISSUE_KEYS, string);
        hashMap.put(QueryParameter.FILTER, string2);
        hashMap.put(QueryParameter.FZ, string3);
        try {
            String string5 = URLConstructor.constructURL(string4, hashMap);
            logger.debug("Downloading features from: " + string5);
            CloseableHttpResponse closeableHttpResponse = this.httpProvider.doGetRequest(string5);
            return this.resolveDownloadResponse(closeableHttpResponse);
        }
        catch (IOException iOException) {
            logger.error("An error occurred while downloading features.", (Throwable)iOException);
            throw new XrayClientCoreGenericException(iOException);
        }
    }

    private InputStream resolveDownloadResponse(CloseableHttpResponse closeableHttpResponse) throws IOException, XrayClientCoreGenericException {
        String string = "Unable to confirm Result of the download..... ";
        ResponseBodyMessageResolverDelegate responseBodyMessageResolverDelegate = new ResponseBodyMessageResolverDelegate();
        InputStream inputStream = null;
        if (closeableHttpResponse != null) {
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            logger.debug("Status Code of Request:" + n);
            if (n == 200) {
                logger.info("Download OK! Status:" + n);
                logger.debug("Download OK! result:" + closeableHttpResponse.getStatusLine().getReasonPhrase());
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                if (httpEntity != null && (inputStream = httpEntity.getContent()) != null) {
                    return inputStream;
                }
            } else {
                String string2 = "Download Failed! Status:" + n;
                String string3 = responseBodyMessageResolverDelegate.resolveResponseBodyMessage((HttpResponse)closeableHttpResponse);
                string = string + string2 + " " + string3;
                logger.error(string2);
            }
        }
        throw new XrayClientCoreGenericException(string);
    }
}

