/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.service.impl;

import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.service.XrayCloudCredentials;
import com.xpandit.xray.service.impl.bean.ConnectionResult;
import com.xpandit.xray.service.impl.bean.TokenGenerationResult;
import com.xpandit.xray.service.impl.delegates.HttpCloudRequestProvider;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.service.impl.delegates.ResponseBodyMessageResolverDelegate;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XrayCloudClientImpl
implements XrayCloudCredentials {
    private static final Logger logger = LogManager.getLogger(XrayCloudClientImpl.class);
    private final HttpCloudRequestProvider httpProvider;

    public XrayCloudClientImpl(String string, HttpRequestProvider.ProxyBean proxyBean) {
        this.httpProvider = new HttpCloudRequestProvider(string, proxyBean);
    }

    public XrayCloudClientImpl(String string, String string2, HttpRequestProvider.ProxyBean proxyBean) {
        this.httpProvider = new HttpCloudRequestProvider(string, string2, proxyBean);
        this.httpProvider.setToken(this.getNewToken().getToken());
    }

    @Override
    public ConnectionResult testConnection() {
        return this.getNewToken().getConnectionResult();
    }

    @Override
    public ConnectionResult isJiraInstance() {
        return ConnectionResult.connectionSuccessful();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TokenGenerationResult getNewToken() {
        if (StringUtils.isBlank((CharSequence)this.getClientId())) throw new XrayClientCoreGenericException("No client ID or client secret defined.");
        if (StringUtils.isBlank((CharSequence)this.getClientSecret())) {
            throw new XrayClientCoreGenericException("No client ID or client secret defined.");
        }
        ResponseBodyMessageResolverDelegate responseBodyMessageResolverDelegate = new ResponseBodyMessageResolverDelegate();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ \"client_id\": ").append("\"").append(this.getClientId()).append("\",").append("\"client_secret\":").append("\"").append(this.getClientSecret()).append("\"}");
        StringEntity stringEntity = new StringEntity(stringBuilder.toString(), ContentType.APPLICATION_JSON);
        try (CloseableHttpResponse closeableHttpResponse = this.httpProvider.doPostRequest(this.httpProvider.getBaseUrl() + "/api/v1/authenticate", (HttpEntity)stringEntity);){
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            if (n == 200) {
                String string = responseBodyMessageResolverDelegate.resolveResponseBodyMessage((HttpResponse)closeableHttpResponse);
                string = StringUtils.replace((String)string, (String)"\"", (String)"");
                TokenGenerationResult tokenGenerationResult2 = TokenGenerationResult.successful(string);
                return tokenGenerationResult2;
            }
            TokenGenerationResult tokenGenerationResult = TokenGenerationResult.failed(closeableHttpResponse);
            return tokenGenerationResult;
        }
        catch (IOException iOException) {
            logger.error("An error occurred while generating a new token", (Throwable)iOException);
            return TokenGenerationResult.failed(iOException);
        }
    }

    @Override
    public String getClientId() {
        return this.httpProvider.getClientId();
    }

    @Override
    public void setClientId(String string) {
        this.httpProvider.setClientId(string);
    }

    @Override
    public String getClientSecret() {
        return this.httpProvider.getClientSecret();
    }

    @Override
    public void setClientSecret(String string) {
        this.httpProvider.setClientSecret(string);
    }

    public HttpRequestProvider getHttpProvider() {
        return this.httpProvider;
    }
}

