/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.xray.model;

import com.xpandit.xray.model.DataParameter;
import com.xpandit.xray.model.FormatBean;
import com.xpandit.xray.model.Parameter;
import com.xpandit.xray.model.QueryParameter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.http.entity.ContentType;

public enum Endpoint {
    XRAY("Xray JSON", "", new Parameter[]{DataParameter.FILEPATH}, ContentType.APPLICATION_JSON),
    XRAY_MULTIPART("Xray JSON multipart", "/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO}, (Triple<String, String, ContentType>)Triple.of((Object)"result", (Object)"results", (Object)ContentType.APPLICATION_JSON), (Triple<String, String, ContentType>)Triple.of((Object)"info", (Object)"info", (Object)ContentType.APPLICATION_JSON)),
    CUCUMBER("Cucumber JSON", "/cucumber", new Parameter[]{DataParameter.FILEPATH}, ContentType.APPLICATION_JSON),
    CUCUMBER_MULTIPART("Cucumber JSON multipart", "/cucumber/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO}, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON),
    BEHAVE("Behave JSON", "/behave", new Parameter[]{DataParameter.FILEPATH}, ContentType.APPLICATION_JSON),
    BEHAVE_MULTIPART("Behave JSON multipart", "/behave/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO}, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON),
    JUNIT("JUnit XML", "/junit", new Parameter[]{DataParameter.FILEPATH, QueryParameter.PROJECT_KEY, QueryParameter.TEST_EXEC_KEY, QueryParameter.TEST_PLAN_KEY, QueryParameter.TEST_ENVIRONMENTS, QueryParameter.REVISION, QueryParameter.FIX_VERSION}, ContentType.APPLICATION_XML),
    JUNIT_MULTIPART("JUnit XML multipart", "/junit/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO, DataParameter.TEST_INFO}, ContentType.APPLICATION_XML, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON),
    NUNIT("NUnit XML", "/nunit", new Parameter[]{DataParameter.FILEPATH, QueryParameter.PROJECT_KEY, QueryParameter.TEST_EXEC_KEY, QueryParameter.TEST_PLAN_KEY, QueryParameter.TEST_ENVIRONMENTS, QueryParameter.REVISION, QueryParameter.FIX_VERSION}, ContentType.APPLICATION_XML),
    NUNIT_MULTIPART("NUnit XML multipart", "/nunit/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO, DataParameter.TEST_INFO}, ContentType.APPLICATION_XML, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON),
    ROBOT("Robot XML", "/robot", new Parameter[]{DataParameter.FILEPATH, QueryParameter.PROJECT_KEY, QueryParameter.TEST_EXEC_KEY, QueryParameter.TEST_PLAN_KEY, QueryParameter.TEST_ENVIRONMENTS, QueryParameter.REVISION, QueryParameter.FIX_VERSION}, ContentType.APPLICATION_XML),
    ROBOT_MULTIPART("Robot XML multipart", "/robot/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO, DataParameter.TEST_INFO}, ContentType.APPLICATION_XML, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON),
    BUNDLE("Compressed .zip file", "/bundle", new Parameter[]{DataParameter.FILEPATH}, ContentType.APPLICATION_OCTET_STREAM),
    TESTNG("TestNG XML", "/testng", new Parameter[]{DataParameter.FILEPATH, QueryParameter.PROJECT_KEY, QueryParameter.TEST_EXEC_KEY, QueryParameter.TEST_PLAN_KEY, QueryParameter.TEST_ENVIRONMENTS, QueryParameter.REVISION, QueryParameter.FIX_VERSION}, ContentType.APPLICATION_XML),
    TESTNG_MULTIPART("TestNG XML multipart", "/testng/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO, DataParameter.TEST_INFO}, ContentType.APPLICATION_XML, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON),
    XUNIT("xUnit XML", "/xunit", new Parameter[]{DataParameter.FILEPATH, QueryParameter.PROJECT_KEY, QueryParameter.TEST_EXEC_KEY, QueryParameter.TEST_PLAN_KEY, QueryParameter.TEST_ENVIRONMENTS, QueryParameter.REVISION, QueryParameter.FIX_VERSION}, ContentType.APPLICATION_XML),
    XUNIT_MULTIPART("xUnit XML multipart", "/xunit/multipart", new Parameter[]{DataParameter.FILEPATH, DataParameter.INFO, DataParameter.TEST_INFO}, ContentType.APPLICATION_XML, ContentType.APPLICATION_JSON, ContentType.APPLICATION_JSON);

    public static final String RAVEN_IMPORTEXECUTION = "/rest/raven/1.0/import/execution";
    public static final String RAVEN_EXPORTFEATURES = "/rest/raven/1.0/export/test";
    public static final String RAVEN_IMPORTFEATURES = "/rest/raven/1.0/import/feature";
    public static final String CLOUD_AUTHENTHICATION = "/api/v1/authenticate";
    public static final String CLOUD_IMPORTEXECUTION = "/api/v1/import/execution";
    public static final String CLOUD_EXPORTFEATURES = "/api/v1/export/cucumber";
    public static final String CLOUD_IMPORTFEATURES = "/api/v1/import/feature";
    private String name;
    private String suffix;
    private ContentType resultsMediaType;
    private String resultsFileServerParamName;
    private String resultsFileCloudParamName;
    private ContentType infoMediaType;
    private String infoFileServerParamName;
    private ContentType testInfoMediaType;
    private String testInfoFileServerParamName;
    private String infoFileCloudParamName;
    private String testInfoFileCloudParamName;
    private Parameter[] urlFields;

    private Endpoint(String string2, String string3, Parameter[] parameterArray) {
        this.name = string2;
        this.suffix = string3;
        this.urlFields = parameterArray;
        this.resultsFileServerParamName = null;
        this.infoFileServerParamName = null;
        this.testInfoFileServerParamName = null;
        this.resultsFileCloudParamName = null;
        this.infoFileCloudParamName = null;
        this.testInfoFileCloudParamName = null;
    }

    private Endpoint(String string2, String string3, Parameter[] parameterArray, ContentType contentType) {
        this(string2, string3, parameterArray);
        this.resultsMediaType = contentType;
    }

    private Endpoint(String string2, String string3, Parameter[] parameterArray, ContentType contentType, ContentType contentType2) {
        this(string2, string3, parameterArray);
        this.resultsMediaType = contentType;
        this.infoMediaType = contentType2;
    }

    private Endpoint(String string2, String string3, Parameter[] parameterArray, ContentType contentType, ContentType contentType2, ContentType contentType3) {
        this(string2, string3, parameterArray);
        this.resultsMediaType = contentType;
        this.infoMediaType = contentType2;
        this.testInfoMediaType = contentType3;
    }

    private Endpoint(String string2, String string3, Parameter[] parameterArray, Triple<String, String, ContentType> triple, Triple<String, String, ContentType> triple2) {
        this(string2, string3, parameterArray, (ContentType)triple.getRight(), (ContentType)triple2.getRight());
        this.resultsFileServerParamName = (String)triple.getLeft();
        this.resultsFileCloudParamName = (String)triple.getMiddle();
        this.infoFileServerParamName = (String)triple2.getLeft();
        this.infoFileCloudParamName = (String)triple2.getMiddle();
    }

    private Endpoint(String string2, String string3, Parameter[] parameterArray, Triple<String, String, ContentType> triple, Triple<String, String, ContentType> triple2, Triple<String, String, ContentType> triple3) {
        this(string2, string3, parameterArray, (ContentType)triple.getRight(), (ContentType)triple2.getRight());
        this.resultsFileServerParamName = (String)triple.getLeft();
        this.resultsFileCloudParamName = (String)triple.getMiddle();
        this.infoFileServerParamName = (String)triple2.getLeft();
        this.infoFileCloudParamName = (String)triple2.getMiddle();
        this.testInfoFileServerParamName = (String)triple3.getLeft();
        this.testInfoFileCloudParamName = (String)triple3.getMiddle();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getName() {
        return this.name;
    }

    public ContentType getResultsMediaType() {
        return this.resultsMediaType;
    }

    public ContentType getInfoFieldMediaType() {
        return this.infoMediaType;
    }

    public ContentType getTestInfoFieldMediaType() {
        return this.testInfoMediaType;
    }

    public Parameter[] getConfigurableFields() {
        if (this.urlFields == null) {
            return new Parameter[0];
        }
        return this.urlFields;
    }

    public String getResultsFileServerParamName() {
        return this.resultsFileServerParamName;
    }

    public String getInfoFileServerParamName() {
        return this.infoFileServerParamName;
    }

    public String getTestInfoFileServerParamName() {
        return this.testInfoFileServerParamName;
    }

    public String getTestInfoFileCloudParamName() {
        return this.testInfoFileCloudParamName;
    }

    public static Endpoint lookupBySuffix(String string) {
        Endpoint endpoint = null;
        for (Endpoint endpoint2 : Endpoint.values()) {
            if (!endpoint2.getSuffix().equals(string)) continue;
            endpoint = endpoint2;
            break;
        }
        return endpoint;
    }

    public static Endpoint lookupByName(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            for (Endpoint endpoint : Endpoint.values()) {
                if (!endpoint.toString().toLowerCase().equals(string.toLowerCase())) continue;
                return endpoint;
            }
        }
        return null;
    }

    public FormatBean toBean() {
        return new FormatBean(this.name, this.suffix, this.urlFields);
    }

    public static String[] getExclusiveCloudEndpoints() {
        return new String[0];
    }

    public static String[] getExclusiveServerEndpoints() {
        return new String[]{Endpoint.BUNDLE.suffix};
    }

    public String getResultsFileCloudParamName() {
        return this.resultsFileCloudParamName;
    }

    public String getInfoFileCloudParamName() {
        return this.infoFileCloudParamName;
    }
}

