/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.task;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.xpandit.plugins.xrayjenkins.Utils.BuilderUtils;
import com.xpandit.plugins.xrayjenkins.Utils.ConfigurationUtils;
import com.xpandit.plugins.xrayjenkins.Utils.CredentialUtil;
import com.xpandit.plugins.xrayjenkins.Utils.EnvironmentVariableUtil;
import com.xpandit.plugins.xrayjenkins.Utils.FileUtils;
import com.xpandit.plugins.xrayjenkins.Utils.FormUtils;
import com.xpandit.plugins.xrayjenkins.Utils.ProxyUtil;
import com.xpandit.plugins.xrayjenkins.exceptions.XrayJenkinsGenericException;
import com.xpandit.plugins.xrayjenkins.factory.ClientFactory;
import com.xpandit.plugins.xrayjenkins.model.CredentialResolver;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import com.xpandit.plugins.xrayjenkins.model.ServerConfiguration;
import com.xpandit.plugins.xrayjenkins.model.XrayInstance;
import com.xpandit.plugins.xrayjenkins.services.enviromentvariables.XrayEnvironmentVariableSetter;
import com.xpandit.plugins.xrayjenkins.task.compatibility.XrayImportBuilderCompatibilityDelegate;
import com.xpandit.xray.exception.XrayClientCoreGenericException;
import com.xpandit.xray.model.Content;
import com.xpandit.xray.model.DataParameter;
import com.xpandit.xray.model.Endpoint;
import com.xpandit.xray.model.FileStream;
import com.xpandit.xray.model.FormatBean;
import com.xpandit.xray.model.ParameterBean;
import com.xpandit.xray.model.QueryParameter;
import com.xpandit.xray.model.StringContent;
import com.xpandit.xray.model.UploadResult;
import com.xpandit.xray.service.XrayImporter;
import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import com.xpandit.xray.util.UploadResultUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayImportBuilder
extends Notifier
implements SimpleBuildStep {
    private static final Logger LOG = LoggerFactory.getLogger(XrayImportBuilder.class);
    private static Gson gson = new GsonBuilder().create();
    private static final String SAME_EXECUTION_CHECKBOX = "importToSameExecution";
    private static final String IMPORT_IN_PARALLEL = "importInParallel";
    private static final String INPUT_INFO_SWITCHER = "inputInfoSwitcher";
    private static final String TEST_INFO_INPUT_SWITCHER = "inputTestInfoSwitcher";
    private static final String SERVER_INSTANCE = "serverInstance";
    private static final String ERROR_LOG = "Error while performing import tasks";
    private static final String TEST_ENVIRONMENTS = "testEnvironments";
    private static final String PROJECT_KEY = "projectKey";
    private static final String TEST_PLAN_KEY = "testPlanKey";
    private static final String FIX_VERSION = "fixVersion";
    private static final String IMPORT_FILE_PATH = "importFilePath";
    private static final String TEST_EXEC_KEY = "testExecKey";
    private static final String REVISION_FIELD = "revision";
    private static final String IMPORT_INFO = "importInfo";
    private static final String TEST_IMPORT_INFO = "testImportInfo";
    private static final String CREDENTIAL_ID = "credentialId";
    private static final String FORMAT_SUFFIX = "formatSuffix";
    private static final String CLOUD_DOC_URL = "https://confluence.xpand-it.com/display/XRAYCLOUD/Import+Execution+Results+-+REST";
    private static final String SERVER_DOC_URL = "https://confluence.xpand-it.com/display/XRAY/Import+Execution+Results+-+REST";
    private static final String MULTIPART = "multipart";
    private static final int MAX_TRIES = 3;
    private String formatSuffix;
    private String serverInstance;
    private String inputInfoSwitcher;
    private String inputTestInfoSwitcher;
    private String endpointName;
    private String projectKey;
    private String testEnvironments;
    private String testPlanKey;
    private String fixVersion;
    private String importFilePath;
    private String testExecKey;
    private String revision;
    private String importInfo;
    private String testImportInfo;
    private String importToSameExecution;
    private String importInParallel;
    private String credentialId;
    @Deprecated
    private Map<String, String> dynamicFields;
    @Deprecated
    private XrayInstance xrayInstance;
    @Deprecated
    private Endpoint endpoint;

    @DataBoundConstructor
    public XrayImportBuilder(String serverInstance, String endpointName, String projectKey, String testEnvironments, String testPlanKey, String fixVersion, String importFilePath, String testExecKey, String revision, String importInfo, String testImportInfo, String inputInfoSwitcher, String inputTestInfoSwitcher, String importToSameExecution, @Nullable String credentialId, String importInParallel) {
        this.serverInstance = serverInstance;
        this.endpointName = endpointName;
        this.credentialId = credentialId;
        Endpoint e = this.lookupForEndpoint();
        this.formatSuffix = e != null ? e.getSuffix() : null;
        this.projectKey = projectKey;
        this.testEnvironments = testEnvironments;
        this.testPlanKey = testPlanKey;
        this.fixVersion = fixVersion;
        this.importFilePath = importFilePath;
        this.testExecKey = testExecKey;
        this.revision = revision;
        this.importInfo = importInfo;
        this.testImportInfo = testImportInfo;
        this.inputInfoSwitcher = inputInfoSwitcher;
        this.inputTestInfoSwitcher = inputTestInfoSwitcher;
        this.importToSameExecution = importToSameExecution;
        this.importInParallel = importInParallel;
        this.dynamicFields = this.getDynamicFieldsMap();
        this.xrayInstance = ConfigurationUtils.getConfiguration(serverInstance);
        this.endpoint = this.lookupForEndpoint();
    }

    private Map<String, String> getDynamicFieldsMap() {
        HashMap<String, String> fields = new HashMap<String, String>();
        this.putNotBlank(fields, PROJECT_KEY, this.projectKey);
        this.putNotBlank(fields, TEST_ENVIRONMENTS, this.testEnvironments);
        this.putNotBlank(fields, TEST_PLAN_KEY, this.testPlanKey);
        this.putNotBlank(fields, FIX_VERSION, this.fixVersion);
        this.putNotBlank(fields, IMPORT_FILE_PATH, this.importFilePath);
        this.putNotBlank(fields, TEST_EXEC_KEY, this.testExecKey);
        this.putNotBlank(fields, REVISION_FIELD, this.revision);
        this.putNotBlank(fields, IMPORT_INFO, this.importInfo);
        this.putNotBlank(fields, INPUT_INFO_SWITCHER, this.inputInfoSwitcher);
        this.putNotBlank(fields, TEST_IMPORT_INFO, this.testImportInfo);
        this.putNotBlank(fields, TEST_INFO_INPUT_SWITCHER, this.inputTestInfoSwitcher);
        return fields;
    }

    private void putNotBlank(Map<String, String> fields, String key, String val) {
        if (StringUtils.isNotBlank((CharSequence)val)) {
            fields.put(key, val);
        }
    }

    public Map<String, String> getDynamicFields() {
        return this.dynamicFields;
    }

    @DataBoundSetter
    public void setDynamicFields(Map<String, String> dynamicFields) {
        this.dynamicFields = dynamicFields;
    }

    public XrayInstance getXrayInstance() {
        return this.xrayInstance;
    }

    @DataBoundSetter
    public void setXrayInstance(XrayInstance xrayInstance) {
        this.xrayInstance = xrayInstance;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @DataBoundSetter
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getFormatSuffix() {
        return this.formatSuffix;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public void setServerInstance(String serverInstance) {
        this.serverInstance = serverInstance;
    }

    public void setFormatSuffix(String formatSuffix) {
        this.formatSuffix = formatSuffix;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getTestEnvironments() {
        return this.testEnvironments;
    }

    public void setTestEnvironments(String testEnvironments) {
        this.testEnvironments = testEnvironments;
    }

    public String getTestPlanKey() {
        return this.testPlanKey;
    }

    public void setTestPlanKey(String testPlanKey) {
        this.testPlanKey = testPlanKey;
    }

    public String getFixVersion() {
        return this.fixVersion;
    }

    public void setFixVersion(String fixVersion) {
        this.fixVersion = fixVersion;
    }

    public String getImportFilePath() {
        return this.importFilePath;
    }

    public void setImportFilePath(String importFilePath) {
        this.importFilePath = importFilePath;
    }

    public String getTestExecKey() {
        return this.testExecKey;
    }

    public void setTestExecKey(String testExecKey) {
        this.testExecKey = testExecKey;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getImportInfo() {
        return this.importInfo;
    }

    public void setImportInfo(String importInfo) {
        this.importInfo = importInfo;
    }

    public String getImportToSameExecution() {
        return this.importToSameExecution;
    }

    public void setImportToSameExecution(String importToSameExecution) {
        this.importToSameExecution = importToSameExecution;
    }

    public String getImportInParallel() {
        return this.importInParallel;
    }

    public void setImportInParallel(String importInParallel) {
        this.importInParallel = importInParallel;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getFormatName() {
        return Endpoint.lookupByName((String)this.endpointName).getName();
    }

    public String getInputInfoSwitcher() {
        return this.inputInfoSwitcher;
    }

    public String getInputTestInfoSwitcher() {
        return this.inputTestInfoSwitcher;
    }

    public void setInputInfoSwitcher(String inputInfoSwitcher) {
        this.inputInfoSwitcher = inputInfoSwitcher;
    }

    public String defaultFormats() {
        XrayImportBuilderCompatibilityDelegate delegate = new XrayImportBuilderCompatibilityDelegate(this);
        delegate.applyCompatibility();
        HashMap<String, FormatBean> formats = new HashMap<String, FormatBean>();
        for (Endpoint e : Endpoint.values()) {
            FormatBean bean = e.toBean();
            formats.put(e.getSuffix(), bean);
            Endpoint endpointObj = this.lookupForEndpoint();
            if (e.name().equals(endpointObj != null ? endpointObj.name() : null)) {
                bean.setFieldsConfiguration(this.getDynamicFieldsMap());
            }
            this.addImportToSameExecField(e, bean);
            this.addImportInParallel(bean);
        }
        return gson.toJson(formats);
    }

    @Nullable
    private Endpoint lookupForEndpoint() {
        Endpoint targetedEndpoint = Endpoint.lookupByName((String)this.endpointName);
        return targetedEndpoint != null ? targetedEndpoint : Endpoint.lookupBySuffix((String)this.endpointName);
    }

    private void addImportToSameExecField(Endpoint e, FormatBean bean) {
        if (BuilderUtils.isGlobExpressionsSupported(e)) {
            ParameterBean pb = new ParameterBean(SAME_EXECUTION_CHECKBOX, "same exec text box", false);
            pb.setConfiguration(this.importToSameExecution);
            bean.getConfigurableFields().add(0, pb);
        }
    }

    private void addImportInParallel(FormatBean bean) {
        ParameterBean importInParallelpb = new ParameterBean(IMPORT_IN_PARALLEL, "import in parallel text box", false);
        importInParallelpb.setConfiguration(this.importInParallel);
        bean.getConfigurableFields().add(importInParallelpb);
    }

    private FilePath getFile(FilePath workspace, String filePath, TaskListener listener) throws IOException, InterruptedException {
        if (workspace == null) {
            throw new XrayJenkinsGenericException("No workspace in this current node");
        }
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new XrayJenkinsGenericException("No file path was specified");
        }
        FilePath file = FileUtils.readFile(workspace, filePath.trim(), listener);
        if (file.isDirectory() || !file.exists()) {
            throw new XrayJenkinsGenericException("File path is a directory or the file doesn't exist");
        }
        return file;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        XrayImporter client;
        XrayImportBuilderCompatibilityDelegate compatibilityDelegate = new XrayImportBuilderCompatibilityDelegate(this);
        compatibilityDelegate.applyCompatibility();
        this.validate(this.getDynamicFieldsMap());
        listener.getLogger().println("Starting XRAY: Results Import Task...");
        listener.getLogger().println("##########################################################");
        listener.getLogger().println("####     Xray is importing the execution results      ####");
        listener.getLogger().println("##########################################################");
        XrayInstance importInstance = ConfigurationUtils.getConfiguration(this.serverInstance);
        if (importInstance == null) {
            XrayEnvironmentVariableSetter.failed("The Jira server configuration of this task was not found.").setAction(build, listener);
            throw new AbortException("The Jira server configuration of this task was not found.");
        }
        if (StringUtils.isBlank((CharSequence)importInstance.getCredentialId()) && StringUtils.isBlank((CharSequence)this.credentialId)) {
            listener.getLogger().println("This XrayInstance requires an User scoped credential.");
            XrayEnvironmentVariableSetter.failed("This XrayInstance requires an User scoped credential.").setAction(build, listener);
            throw new AbortException("This XrayInstance requires an User scoped credential.");
        }
        CredentialResolver credentialResolver = importInstance.getCredential(build).orElseGet(() -> new CredentialResolver(this.credentialId, build, importInstance.getHosting()));
        HttpRequestProvider.ProxyBean proxyBean = ProxyUtil.createProxyBean();
        HostingType hostingType = importInstance.getHosting() == null ? HostingType.SERVER : importInstance.getHosting();
        StandardCredentials credentials = credentialResolver.getCredentials();
        if (credentials == null) {
            String credentialIdNotFound = Optional.ofNullable(importInstance.getCredentialId()).filter(StringUtils::isNotBlank).orElse(this.credentialId);
            String errorTxt = String.format("Unable to create Xray %s results import client! Credential '%s' not found. For Cloud instances: Secret Text credentials are not allowed", hostingType.name(), credentialIdNotFound);
            throw new AbortException(errorTxt);
        }
        if (hostingType == HostingType.CLOUD) {
            client = ClientFactory.getCloudResultsImportClient(credentials, proxyBean).orElseThrow(() -> new XrayJenkinsGenericException("Unable to create Xray Cloud results import client! (check credential type selected)."));
        } else if (hostingType == HostingType.SERVER) {
            client = ClientFactory.getServerResultsImportClient(importInstance.getServerAddress(), credentials, proxyBean).orElseThrow(() -> new XrayJenkinsGenericException("Unable to create Xray Server/DC results import client! (check credential type selected)."));
        } else {
            XrayEnvironmentVariableSetter.failed("Hosting type not recognized.").setAction(build, listener);
            throw new XrayJenkinsGenericException("Hosting type not recognized.");
        }
        EnvVars env = build.getEnvironment(listener);
        String resolved = EnvironmentVariableUtil.expandVariable(env, this.importFilePath);
        Endpoint endpointValue = Endpoint.lookupBySuffix((String)this.endpointName);
        ArrayList<UploadResult> uploadResults = new ArrayList<UploadResult>();
        if (BuilderUtils.isGlobExpressionsSupported(endpointValue)) {
            List<FilePath> files = FileUtils.getFiles(workspace, resolved, listener, launcher.getChannel());
            if ("true".equals(this.importInParallel) && CollectionUtils.isNotEmpty(files) && files.size() > 1) {
                this.importResultsInParallel(build, workspace, listener, importInstance, client, env, uploadResults, files);
            } else {
                this.importResultsSequential(build, workspace, listener, importInstance, client, env, uploadResults, files);
            }
        } else {
            FilePath file = this.getFile(workspace, resolved, listener);
            uploadResults.add(this.tryUploadResults(workspace, listener, client, file, env, null));
        }
        XrayEnvironmentVariableSetter.parseResultImportResponse(uploadResults, hostingType, listener.getLogger()).setAction(build, listener);
    }

    private void importResultsSequential(Run<?, ?> build, FilePath workspace, TaskListener listener, XrayInstance importInstance, XrayImporter client, EnvVars env, List<UploadResult> uploadResults, List<FilePath> files) throws IOException, InterruptedException {
        String key = null;
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        for (FilePath fp : files) {
            UploadResult result = this.uploadResults(workspace, listener, client, env, key, fp);
            uploadResults.add(result);
            if (key != null || !"true".equals(this.importToSameExecution)) continue;
            key = this.getTestExecutionKeyFromResponse(build, listener, importInstance, result);
        }
    }

    private void importResultsInParallel(Run<?, ?> build, FilePath workspace, TaskListener listener, XrayInstance importInstance, XrayImporter client, EnvVars env, List<UploadResult> uploadResults, List<FilePath> files) throws InterruptedException, IOException {
        String key = null;
        if ("true".equals(this.importToSameExecution) && CollectionUtils.isNotEmpty(files)) {
            FilePath file1 = files.get(0);
            UploadResult result = this.uploadResults(workspace, listener, client, env, null, file1);
            uploadResults.add(result);
            files.remove(0);
            key = this.getTestExecutionKeyFromResponse(build, listener, importInstance, result);
        }
        String finalKey = key;
        List results = files.parallelStream().map(file -> this.getUploadResultImportInParallel(workspace, listener, client, env, finalKey, (FilePath)file)).collect(Collectors.toList());
        uploadResults.addAll(results);
    }

    private UploadResult getUploadResultImportInParallel(FilePath workspace, TaskListener listener, XrayImporter client, EnvVars env, String finalKey, FilePath filePath) {
        try {
            return this.uploadResults(workspace, listener, client, env, finalKey, filePath);
        }
        catch (IOException | InterruptedException e) {
            throw new XrayJenkinsGenericException(e);
        }
    }

    private String getTestExecutionKeyFromResponse(Run<?, ?> build, TaskListener listener, XrayInstance importInstance, UploadResult result) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String key = null;
        HostingType instanceType = importInstance.getHosting();
        if (instanceType == HostingType.SERVER) {
            Map testExecIssue;
            Map resultMap = (Map)mapper.readValue(result.getMessage(), Map.class);
            if (MapUtils.isNotEmpty((Map)resultMap) && MapUtils.isNotEmpty((Map)(testExecIssue = (Map)resultMap.get("testExecIssue")))) {
                key = (String)testExecIssue.get("key");
            }
        } else if (instanceType == HostingType.CLOUD) {
            Map map = (Map)mapper.readValue(result.getMessage(), Map.class);
            key = (String)map.get("key");
        } else {
            throw new XrayJenkinsGenericException("Instance type not found.");
        }
        if (key == null && result.getStatusCode() != 202) {
            XrayEnvironmentVariableSetter.failed("No Test Execution Key returned").setAction(build, listener);
            throw new XrayJenkinsGenericException("No Test Execution Key returned");
        }
        return key;
    }

    private UploadResult uploadResults(@Nonnull FilePath workspace, @Nonnull TaskListener listener, XrayImporter client, EnvVars environmentVariables, String key, FilePath filePath) throws InterruptedException, IOException {
        int tries;
        UploadResult result = this.tryUploadResults(workspace, listener, client, filePath, environmentVariables, key);
        for (tries = 1; result.isTooManyRequests() && tries < 3; ++tries) {
            long sleepTimeSeconds = UploadResultUtil.getRetryTime((UploadResult)result).orElse(UploadResultUtil.MAX_RETRY_AFTER_TIME_SECONDS);
            listener.getLogger().println("Too Many Requests: Waiting " + sleepTimeSeconds + " seconds - try #" + tries);
            if (sleepTimeSeconds > UploadResultUtil.MAX_RETRY_AFTER_TIME_SECONDS) {
                String logText = String.format("Too Many Requests: Wait time (%s seconds) exceeds the maximum allowed (%s seconds)", sleepTimeSeconds, UploadResultUtil.MAX_RETRY_AFTER_TIME_SECONDS);
                listener.getLogger().println(logText);
                throw new XrayJenkinsGenericException(result.getMessage());
            }
            if (sleepTimeSeconds > 0L) {
                Thread.sleep(TimeUnit.SECONDS.toMillis(sleepTimeSeconds));
            }
            result = this.tryUploadResults(workspace, listener, client, filePath, environmentVariables, key);
        }
        if (result.isTooManyRequests() && tries >= 3) {
            throw new XrayJenkinsGenericException(result.getMessage());
        }
        return result;
    }

    private UploadResult tryUploadResults(FilePath workspace, TaskListener listener, XrayImporter client, FilePath resultsFile, EnvVars env, @Nullable String sameTestExecutionKey) throws InterruptedException, IOException {
        try {
            Endpoint targetEndpoint = this.lookupForEndpoint();
            Map<QueryParameter, String> queryParams = this.prepareQueryParam(env);
            if (BuilderUtils.isEnvVariableUndefined(this.testExecKey) && StringUtils.isNotBlank((CharSequence)sameTestExecutionKey) && "true".equals(this.importToSameExecution)) {
                if (this.isMultipartEndpoint(targetEndpoint)) {
                    targetEndpoint = BuilderUtils.getGenericEndpointFromMultipartSuffix(targetEndpoint.getSuffix());
                }
                queryParams.put(QueryParameter.TEST_EXEC_KEY, sameTestExecutionKey);
            }
            HashMap<DataParameter, Object> dataParams = new HashMap<DataParameter, Object>();
            if (StringUtils.isNotBlank((CharSequence)this.importFilePath)) {
                FileStream results = new FileStream(resultsFile.getName(), resultsFile.read(), targetEndpoint.getResultsMediaType());
                dataParams.put(DataParameter.FILEPATH, results);
            }
            if (StringUtils.isNotBlank((CharSequence)this.importInfo)) {
                StringContent info;
                String resolved = EnvironmentVariableUtil.expandVariable(env, this.importInfo);
                if (this.inputInfoSwitcher.equals("filePath")) {
                    FilePath infoFile = this.getFile(workspace, resolved, listener);
                    info = new FileStream(infoFile.getName(), infoFile.read(), targetEndpoint.getInfoFieldMediaType());
                } else {
                    info = new StringContent(resolved, targetEndpoint.getInfoFieldMediaType());
                }
                dataParams.put(DataParameter.INFO, info);
            }
            if (StringUtils.isNotBlank((CharSequence)this.testImportInfo)) {
                StringContent testInfo;
                String resolvedTestImportInfo = EnvironmentVariableUtil.expandVariable(env, this.testImportInfo);
                if (this.inputTestInfoSwitcher.equals("filePath")) {
                    FilePath testInfoFile = this.getFile(workspace, resolvedTestImportInfo, listener);
                    testInfo = new FileStream(testInfoFile.getName(), testInfoFile.read(), targetEndpoint.getInfoFieldMediaType());
                } else {
                    testInfo = new StringContent(resolvedTestImportInfo, targetEndpoint.getInfoFieldMediaType());
                }
                dataParams.put(DataParameter.TEST_INFO, testInfo);
            }
            listener.getLogger().println("Starting to import results from " + resultsFile.getName());
            UploadResult result = client.uploadResults(targetEndpoint, dataParams, queryParams);
            dataParams.values().stream().map(Content::getContent).filter(content -> content instanceof AutoCloseable).map(AutoCloseable.class::cast).forEach(content -> this.closeAutoCloseableInstances(listener, (AutoCloseable)content));
            listener.getLogger().println("Response: (" + result.getStatusCode() + ") " + result.getMessage());
            if (result.isOkStatusCode()) {
                listener.getLogger().println("Successfully imported " + targetEndpoint.getName() + " results from " + resultsFile.getName());
            }
            return result;
        }
        catch (XrayJenkinsGenericException | XrayClientCoreGenericException e) {
            LOG.error(ERROR_LOG, e);
            throw new AbortException(e.getMessage());
        }
        catch (IOException e) {
            LOG.error(ERROR_LOG, (Throwable)e);
            listener.error(e.getMessage());
            throw new IOException(e);
        }
    }

    private void closeAutoCloseableInstances(TaskListener listener, AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            listener.getLogger().println("Error closing autocloseable instance " + e);
        }
    }

    private boolean isMultipartEndpoint(Endpoint endpoint) {
        return endpoint.getName().contains(MULTIPART);
    }

    private Map<QueryParameter, String> prepareQueryParam(EnvVars env) {
        EnumMap<QueryParameter, String> queryParams = new EnumMap<QueryParameter, String>(QueryParameter.class);
        queryParams.put(QueryParameter.PROJECT_KEY, EnvironmentVariableUtil.expandVariable(env, this.projectKey));
        queryParams.put(QueryParameter.TEST_EXEC_KEY, EnvironmentVariableUtil.expandVariable(env, this.testExecKey));
        queryParams.put(QueryParameter.TEST_PLAN_KEY, EnvironmentVariableUtil.expandVariable(env, this.testPlanKey));
        queryParams.put(QueryParameter.TEST_ENVIRONMENTS, EnvironmentVariableUtil.expandVariable(env, this.testEnvironments));
        queryParams.put(QueryParameter.REVISION, EnvironmentVariableUtil.expandVariable(env, this.revision));
        queryParams.put(QueryParameter.FIX_VERSION, EnvironmentVariableUtil.expandVariable(env, this.fixVersion));
        return queryParams;
    }

    private void validate(Map<String, String> dynamicFields) throws FormValidation {
        String value;
        if (this.serverInstance == null) {
            LOG.error("configuration id is null");
            throw new XrayJenkinsGenericException("configuration id is null");
        }
        if (this.endpointName == null || this.lookupForEndpoint() == null) {
            LOG.error("passed endpoint is null or could not be found");
            throw new XrayJenkinsGenericException("passed endpoint is null or could not be found");
        }
        if (this.importFilePath == null) {
            LOG.error("importFilePath is null");
            throw new XrayJenkinsGenericException("importFilePath is null");
        }
        for (DataParameter dataParameter : DataParameter.values()) {
            if (!dynamicFields.containsKey(dataParameter.getKey()) || !dataParameter.isRequired() || !StringUtils.isBlank((CharSequence)(value = dynamicFields.get(dataParameter.getKey())))) continue;
            throw FormValidation.error((String)("You must configure the field " + dataParameter.getLabel()));
        }
        for (DataParameter dataParameter : QueryParameter.values()) {
            if (!dynamicFields.containsKey(dataParameter.getKey()) || !dataParameter.isRequired() || !StringUtils.isBlank((CharSequence)(value = dynamicFields.get(dataParameter.getKey())))) continue;
            throw FormValidation.error((String)("You must configure the field " + dataParameter.getLabel()));
        }
        if (this.importFilePath.contains("../")) {
            throw FormValidation.error((String)"You cannot provide file paths for upper directories.");
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getTestImportInfo() {
        return this.testImportInfo;
    }

    public void setTestImportInfo(String testImportInfo) {
        this.testImportInfo = testImportInfo;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        private static long BUILD_STEP_SEED = 0L;
        private long buildID;

        public Descriptor() {
            super(XrayImportBuilder.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return true;
        }

        public XrayImportBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.validateFormData(formData);
            Map<String, String> fields = this.getDynamicFields(formData.getJSONObject("dynamicFields"));
            String credentialId = Optional.ofNullable(formData.get(XrayImportBuilder.CREDENTIAL_ID)).map(Object::toString).filter(StringUtils::isNotBlank).orElse(null);
            return new XrayImportBuilder((String)formData.get(XrayImportBuilder.SERVER_INSTANCE), formData.getString(XrayImportBuilder.FORMAT_SUFFIX), fields.get(XrayImportBuilder.PROJECT_KEY), fields.get(XrayImportBuilder.TEST_ENVIRONMENTS), fields.get(XrayImportBuilder.TEST_PLAN_KEY), fields.get(XrayImportBuilder.FIX_VERSION), fields.get(XrayImportBuilder.IMPORT_FILE_PATH), fields.get(XrayImportBuilder.TEST_EXEC_KEY), fields.get(XrayImportBuilder.REVISION_FIELD), fields.get(XrayImportBuilder.IMPORT_INFO), fields.get(XrayImportBuilder.TEST_IMPORT_INFO), fields.get(XrayImportBuilder.INPUT_INFO_SWITCHER), fields.get(XrayImportBuilder.TEST_INFO_INPUT_SWITCHER), fields.get(XrayImportBuilder.SAME_EXECUTION_CHECKBOX), credentialId, fields.get(XrayImportBuilder.IMPORT_IN_PARALLEL));
        }

        private void validateFormData(JSONObject formData) throws Descriptor.FormException {
            if (StringUtils.isBlank((CharSequence)formData.getString(XrayImportBuilder.SERVER_INSTANCE))) {
                throw new Descriptor.FormException("Xray Results Import Task error, you must provide a valid Jira Instance", XrayImportBuilder.SERVER_INSTANCE);
            }
        }

        private Map<String, String> getDynamicFields(JSONObject configuredFields) {
            HashMap<String, String> dynamicFields = new HashMap<String, String>();
            Set keys = configuredFields.keySet();
            for (String key : keys) {
                String value;
                if (!configuredFields.containsKey((Object)key) || !StringUtils.isNotBlank((CharSequence)(value = configuredFields.getString(key)))) continue;
                dynamicFields.put(key, value);
            }
            return dynamicFields;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            LOG.info("applying XrayImportBuilder to following jobType class: {}", (Object)jobType.getSimpleName());
            return BuilderUtils.isSupportedJobType(jobType);
        }

        public String getDisplayName() {
            return "Xray: Results Import Task";
        }

        public ListBoxModel doFillFormatSuffixItems() {
            ListBoxModel items = new ListBoxModel();
            for (Endpoint e : Endpoint.values()) {
                items.add(e.getName(), e.getSuffix());
            }
            return items;
        }

        public ListBoxModel doFillServerInstanceItems(@AncestorInPath Job job) {
            if (job == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || job != null && !job.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return FormUtils.getServerInstanceItems();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item, @org.kohsuke.stapler.QueryParameter String credentialId) {
            return CredentialUtil.getUserScopedCredentialsListBoxModel(item, credentialId);
        }

        public FormValidation doCheckCredentialId(@org.kohsuke.stapler.QueryParameter String value, @org.kohsuke.stapler.QueryParameter String serverInstance) {
            XrayInstance xrayInstance = ConfigurationUtils.getConfigurationOrFirstAvailable(serverInstance);
            if (xrayInstance != null && StringUtils.isBlank((CharSequence)xrayInstance.getCredentialId()) && StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"This XrayInstance requires an User scoped credential.");
            }
            return FormValidation.ok();
        }

        public long defaultBuildID() {
            return this.buildID;
        }

        public void setBuildID() {
            this.buildID = ++BUILD_STEP_SEED;
        }

        public String defaultFormats() {
            HashMap<String, FormatBean> formats = new HashMap<String, FormatBean>();
            for (Endpoint e : Endpoint.values()) {
                FormatBean bean = e.toBean();
                this.addImportToSameExecField(e, bean);
                this.addImportInParallel(bean);
                formats.put(e.getSuffix(), bean);
            }
            return gson.toJson(formats);
        }

        private void addImportToSameExecField(Endpoint e, FormatBean bean) {
            if (BuilderUtils.isGlobExpressionsSupported(e)) {
                ParameterBean pb = new ParameterBean(XrayImportBuilder.SAME_EXECUTION_CHECKBOX, "same exec text box", false);
                bean.getConfigurableFields().add(0, pb);
            }
        }

        private void addImportInParallel(FormatBean bean) {
            ParameterBean pb = new ParameterBean(XrayImportBuilder.IMPORT_IN_PARALLEL, "import in parallel text box", false);
            bean.getConfigurableFields().add(pb);
        }

        public List<XrayInstance> getServerInstances() {
            return ServerConfiguration.get().getServerInstances();
        }

        public FormValidation doCheckServerInstance(@AncestorInPath Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            return ConfigurationUtils.anyAvailableConfiguration() ? FormValidation.ok() : FormValidation.error((String)"No configured Server Instances.");
        }

        public String getCloudHostingTypeName() {
            return HostingType.getCloudHostingName();
        }

        public String getServerHostingTypeName() {
            return HostingType.getServerHostingName();
        }

        public JSONObject getExclusiveCloudEndpoints() {
            String[] exclusiveCloudEndpoints = Endpoint.getExclusiveCloudEndpoints();
            JSONObject jsonExclusiveCloudEndpoints = new JSONObject();
            for (String suffix : exclusiveCloudEndpoints) {
                jsonExclusiveCloudEndpoints.put(suffix, (Object)suffix);
            }
            return jsonExclusiveCloudEndpoints;
        }

        public JSONObject getExclusiveServerEndpoints() {
            String[] exclusiveServerEndpoints = Endpoint.getExclusiveServerEndpoints();
            JSONObject jsonExclusiveServerEndpoints = new JSONObject();
            for (String suffix : exclusiveServerEndpoints) {
                jsonExclusiveServerEndpoints.put(suffix, (Object)suffix);
            }
            return jsonExclusiveServerEndpoints;
        }

        public String getCloudDocUrl() {
            return XrayImportBuilder.CLOUD_DOC_URL;
        }

        public String getServerDocUrl() {
            return XrayImportBuilder.SERVER_DOC_URL;
        }
    }
}

