/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.model;

import com.xpandit.plugins.xrayjenkins.model.CredentialResolver;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import hudson.model.Run;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class XrayInstance {
    private String configID;
    private String alias;
    private String serverAddress;
    private HostingType hosting;
    private String credentialId;
    private CredentialResolver credentialResolver;

    @DataBoundConstructor
    public XrayInstance(String configID, String alias, HostingType hosting, String serverAddress, String credentialId) {
        this.configID = StringUtils.isBlank((CharSequence)configID) ? UUID.randomUUID().toString() : configID;
        this.alias = alias;
        this.hosting = hosting;
        this.serverAddress = serverAddress;
        this.credentialId = credentialId;
    }

    public String getConfigID() {
        return this.configID;
    }

    public void setConfigID(String configID) {
        this.configID = configID;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Optional<CredentialResolver> getCredential(Run<?, ?> runContext) {
        if (this.credentialResolver == null && StringUtils.isNotBlank((CharSequence)this.credentialId)) {
            this.credentialResolver = new CredentialResolver(this.credentialId, runContext, this.hosting);
        }
        return Optional.ofNullable(this.credentialResolver);
    }

    public HostingType getHosting() {
        return this.hosting;
    }

    public void setHosting(HostingType hosting) {
        this.hosting = hosting;
    }

    @Nullable
    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(@Nullable String credentialId) {
        this.credentialId = credentialId;
    }
}

