/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.model;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.xpandit.plugins.xrayjenkins.Utils.CredentialUtil;
import com.xpandit.plugins.xrayjenkins.model.HostingType;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.User;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class CredentialResolver {
    private final String credentialId;
    private final Run<?, ?> run;
    private final HostingType hostingType;
    private StandardCredentials credentials;

    public CredentialResolver(String credentialId, Run<?, ?> run, HostingType hostingType) {
        this.credentialId = credentialId;
        this.run = run;
        this.hostingType = hostingType;
    }

    @Nullable
    public StandardCredentials getCredentials() {
        this.resolveCredential();
        return this.credentials;
    }

    private void resolveCredential() {
        if (StringUtils.isNotBlank((String)this.credentialId)) {
            this.credentials = this.findCredentialById();
        }
    }

    @Nullable
    private StandardCredentials findCredentialById() {
        StandardCredentials credential = this.findSystemCredentialById();
        if (credential != null) {
            return credential;
        }
        Authentication buildUserAuth = Optional.ofNullable(this.run.getCause(Cause.UserIdCause.class)).map(Cause.UserIdCause::getUserId).filter(StringUtils::isNotBlank).map(userId -> User.getById((String)userId, (boolean)false)).map(User::impersonate).orElse(null);
        List<StandardCredentials> userScopedCredentials = CredentialUtil.getAllUserScopedCredentials((Item)this.run.getParent(), buildUserAuth);
        StandardCredentials credentialsMatched = userScopedCredentials.stream().filter(cred -> StringUtils.equals((String)cred.getId(), (String)this.credentialId)).findFirst().orElse(null);
        if (this.hostingType == HostingType.CLOUD && credentialsMatched != null && CredentialUtil.hasNonUsernamePasswordCredentials(userScopedCredentials, Collections.singleton(credentialsMatched.getId()))) {
            return null;
        }
        return credentialsMatched;
    }

    @Nullable
    private StandardCredentials findSystemCredentialById() {
        StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.credentialId, StandardUsernamePasswordCredentials.class, this.run, (List)null);
        if (usernamePasswordCredentials != null) {
            return usernamePasswordCredentials;
        }
        return (StandardCredentials)CredentialsProvider.findCredentialById((String)this.credentialId, StringCredentials.class, this.run, (List)null);
    }
}

