/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.Utils;

import com.xpandit.xray.service.impl.delegates.HttpRequestProvider;
import hudson.ProxyConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;

public class ProxyUtil {
    private ProxyUtil() {
    }

    @Nullable
    public static HttpRequestProvider.ProxyBean createProxyBean() {
        ProxyConfiguration proxyConfiguration = Optional.ofNullable(Jenkins.getInstanceOrNull()).map(jenkins -> jenkins.proxy).orElse(null);
        if (proxyConfiguration != null) {
            HttpHost proxy = ProxyUtil.getProxy(proxyConfiguration);
            CredentialsProvider credentialsProvider = ProxyUtil.getCredentialsProvider(proxyConfiguration);
            List<Pattern> noProxyUrlPatterns = ProxyUtil.getNoProxyUrlPatterns(proxyConfiguration.noProxyHost);
            return new HttpRequestProvider.ProxyBean(proxy, credentialsProvider, noProxyUrlPatterns);
        }
        return null;
    }

    private static List<Pattern> getNoProxyUrlPatterns(String noProxyHost) {
        if (StringUtils.isBlank((CharSequence)noProxyHost)) {
            return Collections.emptyList();
        }
        return Stream.of(noProxyHost.split("[ \t\n,|]+")).filter(StringUtils::isNotEmpty).map(ProxyUtil::makeUrlPattern).collect(Collectors.toList());
    }

    private static Pattern makeUrlPattern(String noProxyHostElement) {
        String regexp = noProxyHostElement.contains("://") ? noProxyHostElement.replace(".", "\\.").replace("*", ".*") : "https?://" + noProxyHostElement.replace(".", "\\.").replace("*", "[^/:]*") + "(:[0-9]+)?(/.*)?";
        return Pattern.compile(regexp);
    }

    private static HttpHost getProxy(ProxyConfiguration proxyConfiguration) {
        return new HttpHost(proxyConfiguration.name, proxyConfiguration.port);
    }

    private static CredentialsProvider getCredentialsProvider(ProxyConfiguration proxyConfiguration) {
        if (StringUtils.isBlank((CharSequence)proxyConfiguration.getUserName())) {
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(proxyConfiguration.name, proxyConfiguration.port);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfiguration.getUserName(), proxyConfiguration.getPassword());
        credentialsProvider.setCredentials(authScope, (Credentials)credentials);
        return credentialsProvider;
    }
}

