/*
 * Decompiled with CFR 0.152.
 */
package com.xpandit.plugins.xrayjenkins.Utils;

import com.google.common.collect.Sets;
import com.xpandit.plugins.xrayjenkins.exceptions.XrayJenkinsGenericException;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileUtils {
    private static String FEATURE_FILE_EXTENSION = ".feature";

    private FileUtils() {
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List<FilePath> getFeatureFilesFromWorkspace(FilePath workspace, String path, TaskListener listener) throws IOException, InterruptedException {
        String errors = FileUtils.getErrors(workspace, path, listener);
        if (errors != null) {
            throw new XrayJenkinsGenericException(errors);
        }
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        FilePath filePath = FileUtils.readFile(workspace, path, listener);
        if (filePath.isDirectory()) {
            paths.addAll(Arrays.asList(filePath.list("*" + FEATURE_FILE_EXTENSION, "", false)));
            List children = filePath.list();
            for (FilePath child : children) {
                if (!child.isDirectory()) continue;
                paths.addAll(FileUtils.getFeatureFilesFromWorkspace(workspace, child.toString(), listener));
            }
        } else if (FileUtils.isFeatureFile(filePath)) {
            paths.add(filePath);
        } else {
            throw new XrayJenkinsGenericException("The path is not a folder or a single feature file");
        }
        return paths;
    }

    private static boolean isFeatureFile(FilePath filePath) throws IOException, InterruptedException {
        return filePath.exists() && StringUtils.endsWith((CharSequence)filePath.getName(), (CharSequence)FEATURE_FILE_EXTENSION);
    }

    public static Set<String> getFeatureFileNamesFromWorkspace(FilePath workspace, String path, TaskListener listener) throws IOException, InterruptedException {
        List<FilePath> filePaths = FileUtils.getFeatureFilesFromWorkspace(workspace, path, listener);
        HashSet fileNames = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(filePaths)) {
            for (FilePath fp : filePaths) {
                String remoteFileName = fp.getRemote();
                if (!StringUtils.isNotBlank((CharSequence)remoteFileName)) continue;
                fileNames.add(remoteFileName);
            }
        }
        return Collections.unmodifiableSet(fileNames);
    }

    private static String getErrors(FilePath workspace, String path, TaskListener listener) {
        LinkedList<String> errors = new LinkedList<String>();
        if (workspace == null) {
            errors.add("workspace cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            errors.add("The folder path cannot be null nor empty");
        }
        if (listener == null) {
            errors.add("The task listener cannot be null");
        }
        return errors.isEmpty() ? null : StringUtils.join(errors, (String)"\n");
    }

    public static List<FilePath> getFiles(FilePath workspace, String globExpression, TaskListener listener, VirtualChannel channel) throws IOException, InterruptedException {
        FilePath base;
        if (workspace == null) {
            throw new XrayJenkinsGenericException("workspace cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)globExpression)) {
            throw new XrayJenkinsGenericException("The file path cannot be null nor empty");
        }
        String regexExpression = globExpression;
        String root = FilenameUtils.getPrefix((String)globExpression);
        if (!StringUtils.isBlank((CharSequence)root)) {
            String path = FilenameUtils.getPath((String)globExpression);
            String fileName = FilenameUtils.getName((String)globExpression);
            regexExpression = FilenameUtils.concat((String)path, (String)fileName);
            base = new FilePath(channel, root);
        } else {
            base = workspace;
        }
        List<FilePath> filePaths = Stream.of(base.list(regexExpression, "", false)).filter(Objects::nonNull).collect(Collectors.toList());
        if (filePaths.isEmpty()) {
            listener.getLogger().println("0 files found. Please make sure the path provided is valid and is not a directory");
            throw new XrayJenkinsGenericException("0 files found. Please make sure the path provided is valid and is not a directory");
        }
        filePaths.forEach(filePath -> listener.getLogger().println("File found: " + filePath.getRemote()));
        return filePaths;
    }

    public static FilePath readFile(FilePath workspace, String filePath, TaskListener listener) {
        FilePath f = new FilePath(workspace, filePath);
        listener.getLogger().println("File: " + f.getRemote());
        return f;
    }

    public static boolean isApplicableAsModifiedFile(FilePath filePath, String lastModified) {
        try {
            if (StringUtils.isBlank((CharSequence)lastModified)) {
                return true;
            }
            int lastModifiedIntValue = FileUtils.getLastModifiedIntValue(lastModified);
            long diffInMillis = new Date().getTime() - filePath.lastModified();
            long diffInHour = diffInMillis / 3600000L;
            return diffInHour <= (long)lastModifiedIntValue;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }

    private static int getLastModifiedIntValue(String lastModified) {
        try {
            int m = Integer.parseInt(lastModified);
            if (m <= 0) {
                throw new XrayJenkinsGenericException("last modified value must be a positive integer");
            }
            return m;
        }
        catch (NumberFormatException e) {
            throw new XrayJenkinsGenericException("last modified value is not an integer");
        }
    }
}

