/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.storage;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Action;
import hudson.util.RobustReflectionConverter;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.support.PipelineIOUtils;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;

public class SimpleXStreamFlowNodeStorage
extends FlowNodeStorage {
    private final File dir;
    private final FlowExecution exec;
    private final LoadingCache<String, FlowNode> nodeCache = Caffeine.newBuilder().softValues().build(key -> this.load((String)key).node);
    private static final Logger LOGGER = Logger.getLogger(SimpleXStreamFlowNodeStorage.class.getName());
    private transient HashMap<String, FlowNode> deferredWrite = null;
    private transient HashSet<String> delayAutopersistIds = null;
    public static final XStream2 XSTREAM = new XStream2();
    private static final Field FlowNode$exec;
    private static final Field FlowNode$parents;
    private static final Field FlowNode$parentIds;
    private static final Method FlowNode_setActions;

    public SimpleXStreamFlowNodeStorage(FlowExecution exec, File dir) {
        this.exec = exec;
        this.dir = dir;
    }

    @Override
    public FlowNode getNode(String id) throws IOException {
        try {
            FlowNode maybeOutput;
            if (this.deferredWrite != null && (maybeOutput = this.deferredWrite.get(id)) != null) {
                return maybeOutput;
            }
            return (FlowNode)this.nodeCache.get((Object)id);
        }
        catch (CompletionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof NoSuchFileException) {
                LOGGER.finer("Tried to load FlowNode where file does not exist, for id " + id);
                return null;
            }
            throw new IOException(cause);
        }
    }

    @Override
    public void storeNode(@NonNull FlowNode n, boolean delayWritingActions) throws IOException {
        if (delayWritingActions) {
            if (this.deferredWrite == null) {
                this.deferredWrite = new HashMap();
            }
            this.deferredWrite.put(n.getId(), n);
            if (this.delayAutopersistIds == null) {
                this.delayAutopersistIds = new HashSet(2);
            }
            this.delayAutopersistIds.add(n.getId());
        } else {
            this.flushNode(n);
        }
    }

    @Override
    public void storeNode(FlowNode n) throws IOException {
        this.storeNode(n, false);
    }

    @Override
    public void autopersist(@NonNull FlowNode n) throws IOException {
        if (this.deferredWrite != null && this.deferredWrite.containsKey(n.getId())) {
            this.flushNode(n);
        }
        if (this.delayAutopersistIds != null) {
            this.delayAutopersistIds.remove(n.getId());
        }
    }

    @Override
    public void flushNode(@NonNull FlowNode n) throws IOException {
        this.writeNode(n, n.getActions());
        if (this.deferredWrite != null) {
            this.deferredWrite.remove(n.getId());
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.deferredWrite != null && !this.deferredWrite.isEmpty()) {
            Collection<FlowNode> toWrite = this.deferredWrite.values();
            for (FlowNode f : toWrite) {
                this.writeNode(f, f.getActions());
            }
            this.deferredWrite.clear();
        }
    }

    private File getNodeFile(String id) {
        return new File(this.dir, id + ".xml");
    }

    public List<Action> loadActions(@NonNull FlowNode node) throws IOException {
        if (!this.getNodeFile(node.getId()).exists()) {
            return new ArrayList<Action>();
        }
        return this.load(node.getId()).actions();
    }

    private void writeNode(FlowNode node, List<Action> actions) throws IOException {
        this.nodeCache.put((Object)node.getId(), (Object)node);
        PipelineIOUtils.writeByXStream(new Tag(node, actions), this.getNodeFile(node.getId()), XSTREAM, !this.isAvoidAtomicWrite());
    }

    public void saveActions(@NonNull FlowNode node, @NonNull List<Action> actions) throws IOException {
        if (this.delayAutopersistIds != null && this.delayAutopersistIds.contains(node.getId())) {
            this.deferredWrite.put(node.getId(), node);
        } else {
            this.writeNode(node, actions);
        }
    }

    @Override
    public boolean isPersistedFully() {
        return this.deferredWrite == null || this.deferredWrite.isEmpty();
    }

    private Tag load(String id) throws IOException {
        XmlFile nodeFile = new XmlFile((XStream)XSTREAM, this.getNodeFile(id));
        Tag v = (Tag)nodeFile.read();
        if (v.node == null) {
            throw new IOException("failed to load flow node from " + String.valueOf(nodeFile) + ": " + nodeFile.asString());
        }
        try {
            FlowNode$exec.set(v.node, this.exec);
        }
        catch (IllegalAccessException e) {
            throw (IllegalAccessError)new IllegalAccessError("Failed to set owner").initCause(e);
        }
        v.storeActions();
        for (FlowNodeAction a : Util.filter(v.actions(), FlowNodeAction.class)) {
            a.onLoad(v.node);
        }
        return v;
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void loadXstream() {
        XSTREAM.getClass();
    }

    static {
        XSTREAM.registerConverter(new Converter(){
            private final RobustReflectionConverter ref = new RobustReflectionConverter(XSTREAM.getMapper(), JVM.newReflectionProvider());
            private final Map<FlowNode, String> ids = Caffeine.newBuilder().weakKeys().build().asMap();

            public boolean canConvert(Class type) {
                return FlowNode.class.isAssignableFrom(type);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                this.ref.marshal(source, writer, context);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                try {
                    FlowNode n;
                    block8: {
                        n = (FlowNode)this.ref.unmarshal(reader, context);
                        this.ids.put(n, reader.getValue());
                        try {
                            List parents = (List)FlowNode$parents.get(n);
                            if (parents != null) {
                                ArrayList<String> parentIds = (ArrayList<String>)FlowNode$parentIds.get(n);
                                assert (parentIds == null);
                                parentIds = new ArrayList<String>(parents.size());
                                for (FlowNode parent : parents) {
                                    String id = this.ids.get(parent);
                                    assert (id != null);
                                    parentIds.add(id);
                                }
                                FlowNode$parents.set(n, null);
                                FlowNode$parentIds.set(n, parentIds);
                            }
                        }
                        catch (Exception x) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)x);
                        }
                    }
                    return n;
                }
                catch (RuntimeException x) {
                    x.printStackTrace();
                    throw x;
                }
            }
        });
        XSTREAM.alias("Tag", Tag.class);
        XSTREAM.aliasPackage("cps.n", "org.jenkinsci.plugins.workflow.cps.nodes");
        XSTREAM.aliasPackage("wf.a", "org.jenkinsci.plugins.workflow.actions");
        XSTREAM.aliasPackage("s.a", "org.jenkinsci.plugins.workflow.support.actions");
        XSTREAM.aliasPackage("cps.a", "org.jenkinsci.plugins.workflow.cps.actions");
        try {
            FlowNode$exec = FlowNode.class.getDeclaredField("exec");
            FlowNode$exec.setAccessible(true);
            FlowNode$parents = FlowNode.class.getDeclaredField("parents");
            FlowNode$parents.setAccessible(true);
            FlowNode$parentIds = FlowNode.class.getDeclaredField("parentIds");
            FlowNode$parentIds.setAccessible(true);
            FlowNode_setActions = FlowNode.class.getDeclaredMethod("setActions", List.class);
            FlowNode_setActions.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static class Tag {
        final FlowNode node;
        @CheckForNull
        private final List<Action> actions;

        private Tag(@NonNull FlowNode node, @NonNull List<Action> actions) {
            this.node = node;
            this.actions = actions.isEmpty() ? null : new ArrayList<Action>(actions);
        }

        private void storeActions() {
            try {
                FlowNode_setActions.invoke((Object)this.node, this.actions());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        @NonNull
        public List<Action> actions() {
            return this.actions != null ? Collections.unmodifiableList(this.actions) : Collections.emptyList();
        }
    }
}

