/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.storage;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Action;
import hudson.util.IOUtils;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.support.PipelineIOUtils;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;

public class BulkFlowNodeStorage
extends FlowNodeStorage {
    private final File dir;
    private final FlowExecution exec;
    private transient Map<String, Tag> nodes = null;
    private boolean isModified = false;
    public static final XStream2 XSTREAM = new XStream2();
    private static final Field FlowNode$exec;
    private static final Method FlowNode_setActions;

    File getStoreFile() throws IOException {
        return new File(this.dir, "flowNodeStore.xml");
    }

    public BulkFlowNodeStorage(FlowExecution exec, File dir) {
        this.exec = exec;
        this.dir = dir;
        this.nodes = null;
        this.setAvoidAtomicWrite(true);
    }

    private Map<String, Tag> getOrLoadNodes() throws IOException {
        if (this.nodes == null) {
            if (this.dir.exists()) {
                File storeFile = this.getStoreFile();
                if (storeFile.exists()) {
                    Map roughNodes = null;
                    try {
                        roughNodes = (Map)XSTREAM.fromXML(this.getStoreFile());
                    }
                    catch (Exception ex) {
                        this.nodes = new HashMap<String, Tag>();
                        throw new IOException("Failed to read nodes", ex);
                    }
                    if (roughNodes == null) {
                        this.nodes = new HashMap<String, Tag>();
                        throw new IOException("Unable to load nodes, invalid data");
                    }
                    for (Tag t : roughNodes.values()) {
                        FlowNode fn = t.node;
                        try {
                            FlowNode$exec.set(fn, this.exec);
                        }
                        catch (IllegalAccessException e) {
                            throw (IllegalAccessError)new IllegalAccessError("Failed to set owner").initCause(e);
                        }
                        t.storeActions();
                        for (FlowNodeAction a : Util.filter(t.actions(), FlowNodeAction.class)) {
                            a.onLoad(fn);
                        }
                    }
                    this.nodes = roughNodes;
                } else {
                    this.nodes = new HashMap<String, Tag>();
                }
            } else {
                IOUtils.mkdirs((File)this.dir);
                this.nodes = new HashMap<String, Tag>();
            }
        }
        return this.nodes;
    }

    @Override
    @CheckForNull
    public FlowNode getNode(@NonNull String id) throws IOException {
        Tag t = this.getOrLoadNodes().get(id);
        return t != null ? t.node : null;
    }

    @Override
    public void storeNode(@NonNull FlowNode n, boolean delayWritingActions) throws IOException {
        Tag t = this.getOrLoadNodes().get(n.getId());
        if (t != null) {
            t.node = n;
            List act = n.getActions();
            t.actions = new ArrayList<Action>(act);
        } else {
            this.getOrLoadNodes().put(n.getId(), new Tag(n, n.getActions()));
        }
        this.isModified = true;
        if (!delayWritingActions) {
            this.flush();
        }
    }

    @Override
    public void storeNode(FlowNode n) throws IOException {
        this.flushNode(n);
    }

    @Override
    public void flushNode(@NonNull FlowNode n) throws IOException {
        this.storeNode(n, false);
    }

    @Override
    public void flush() throws IOException {
        if (this.nodes != null && this.isModified) {
            if (!this.dir.exists()) {
                IOUtils.mkdirs((File)this.dir);
            }
            TreeMap<String, Tag> sorted = new TreeMap<String, Tag>(BulkFlowNodeStorage::sort);
            sorted.putAll(this.nodes);
            PipelineIOUtils.writeByXStream(new LinkedHashMap(sorted), this.getStoreFile(), XSTREAM, !this.isAvoidAtomicWrite());
            this.isModified = false;
        }
    }

    private static int sort(String k1, String k2) {
        try {
            return Integer.parseInt(k1) - Integer.parseInt(k2);
        }
        catch (NumberFormatException x) {
            return k1.compareTo(k2);
        }
    }

    public List<Action> loadActions(@NonNull FlowNode node) throws IOException {
        Tag t = this.getOrLoadNodes().get(node.getId());
        return t != null ? t.actions() : Collections.emptyList();
    }

    public void saveActions(@NonNull FlowNode node, @NonNull List<Action> actions) throws IOException {
        Map<String, Tag> map = this.getOrLoadNodes();
        Tag t = map.get(node.getId());
        if (t != null) {
            t.node = node;
            List act = node.getActions();
            t.actions = new ArrayList<Action>(act);
        } else {
            map.put(node.getId(), new Tag(node, actions));
        }
        this.isModified = true;
    }

    @Override
    public boolean isPersistedFully() {
        return !this.isModified;
    }

    static {
        XSTREAM.alias("Tag", Tag.class);
        XSTREAM.aliasPackage("cps.n", "org.jenkinsci.plugins.workflow.cps.nodes");
        XSTREAM.aliasPackage("wf.a", "org.jenkinsci.plugins.workflow.actions");
        XSTREAM.aliasPackage("s.a", "org.jenkinsci.plugins.workflow.support.actions");
        XSTREAM.aliasPackage("cps.a", "org.jenkinsci.plugins.workflow.cps.actions");
        try {
            FlowNode$exec = FlowNode.class.getDeclaredField("exec");
            FlowNode$exec.setAccessible(true);
            FlowNode_setActions = FlowNode.class.getDeclaredMethod("setActions", List.class);
            FlowNode_setActions.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    private static class Tag {
        FlowNode node;
        @CheckForNull
        private List<Action> actions;

        private Tag(@NonNull FlowNode node, @NonNull List<Action> actions) {
            this.node = node;
            this.actions = actions.isEmpty() ? null : new ArrayList<Action>(actions);
        }

        private void storeActions() {
            try {
                FlowNode_setActions.invoke((Object)this.node, this.actions());
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }

        @NonNull
        public List<Action> actions() {
            return this.actions != null ? Collections.unmodifiableList(this.actions) : Collections.emptyList();
        }
    }
}

