/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.visualization.table;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.visualization.table.FlowNodeViewColumn;
import org.jenkinsci.plugins.workflow.visualization.table.FlowNodeViewColumnDescriptor;

public class FlowGraphTable {
    private final FlowExecution execution;
    private List<FlowNode> heads;
    private List<Row> rows;
    private List<FlowNodeViewColumn> columns;

    public FlowGraphTable(@Nullable FlowExecution execution) {
        this.execution = execution;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public List<FlowNodeViewColumn> getColumns() {
        return this.columns;
    }

    public void build() {
        if (this.execution != null) {
            Map<FlowNode, Row> rows = this.createAllRows();
            Row firstRow = this.buildForwardReferences(rows);
            if (firstRow != null) {
                this.buildTreeFromGraph(rows);
                this.buildTreeDepth(firstRow);
                this.rows = Collections.unmodifiableList(this.order(firstRow));
            } else {
                this.rows = List.of();
            }
        } else {
            this.rows = Collections.emptyList();
        }
        this.columns = Collections.unmodifiableList(FlowNodeViewColumnDescriptor.getDefaultInstances());
    }

    private Map<FlowNode, Row> createAllRows() {
        this.heads = this.execution.getCurrentHeads();
        DepthFirstScanner scanner = new DepthFirstScanner();
        scanner.setup(this.heads);
        LinkedHashMap<FlowNode, Row> rows = new LinkedHashMap<FlowNode, Row>();
        for (FlowNode n : scanner) {
            Row row = new Row(n);
            rows.put(n, row);
        }
        return rows;
    }

    @CheckForNull
    private Row buildForwardReferences(Map<FlowNode, Row> rows) {
        Row firstRow = null;
        for (Row r : rows.values()) {
            FlowNode n = r.node;
            for (FlowNode p : n.getParents()) {
                rows.get(p).addGraphChild(r);
            }
            if (n.getParents().isEmpty()) {
                if (firstRow == null) {
                    firstRow = r;
                } else {
                    firstRow.addGraphSibling(r);
                }
            }
            if (!r.isEnd()) continue;
            BlockEndNode en = (BlockEndNode)r.node;
            Row sr = rows.get(en.getStartNode());
            if (r.hasStartTime && sr.hasStartTime) {
                sr.durationMillis = r.startTimeMillis - sr.startTimeMillis;
                sr.hasTiming = true;
            }
            assert (sr.endNode == null) : "start/end mapping should be 1:1";
            sr.endNode = en;
        }
        return firstRow;
    }

    private void buildTreeFromGraph(Map<FlowNode, Row> rows) {
        for (Row r : rows.values()) {
            Row c;
            if (r.isStart()) {
                c = r.firstGraphChild;
                while (c != null) {
                    r.addTreeChild(c);
                    c = c.nextGraphSibling;
                }
                continue;
            }
            if (r.isEnd()) {
                BlockEndNode en = (BlockEndNode)r.node;
                Row sr = rows.get(en.getStartNode());
                Row c2 = r.firstGraphChild;
                while (c2 != null) {
                    sr.addTreeSibling(c2);
                    c2 = c2.nextGraphSibling;
                }
                continue;
            }
            c = r.firstGraphChild;
            while (c != null) {
                r.addTreeSibling(c);
                c = c.nextGraphSibling;
            }
        }
    }

    private void buildTreeDepth(Row r) {
        r.treeDepth = 0;
        Stack<Row> q = new Stack<Row>();
        q.add(r);
        while (!q.isEmpty()) {
            r = (Row)q.pop();
            if (r.firstTreeChild != null) {
                q.add(r.firstTreeChild);
                r.firstTreeChild.treeDepth = r.treeDepth + 1;
            }
            if (r.nextTreeSibling == null) continue;
            q.add(r.nextTreeSibling);
            r.nextTreeSibling.treeDepth = r.treeDepth;
        }
    }

    private List<Row> order(Row r) {
        ArrayList<Row> rows = new ArrayList<Row>();
        Stack<Row> ancestors = new Stack<Row>();
        while (true) {
            rows.add(r);
            if (r.firstTreeChild != null) {
                if (r.nextTreeSibling != null) {
                    ancestors.push(r.nextTreeSibling);
                }
                r = r.firstTreeChild;
                continue;
            }
            if (r.nextTreeSibling != null) {
                r = r.nextTreeSibling;
                continue;
            }
            if (ancestors.isEmpty()) break;
            r = (Row)ancestors.pop();
        }
        for (Row newRow : rows) {
            if (newRow.durationMillis != 0L || !newRow.hasStartTime) continue;
            if (newRow.node instanceof BlockStartNode && newRow.endNode == null) {
                newRow.durationMillis = System.currentTimeMillis() - newRow.startTimeMillis;
                newRow.hasTiming = true;
                continue;
            }
            Row nextRow = newRow.firstGraphChild;
            if (!nextRow.hasStartTime) continue;
            newRow.durationMillis = nextRow.startTimeMillis - newRow.startTimeMillis;
            newRow.hasTiming = true;
        }
        return rows;
    }

    public static class Row {
        private final FlowNode node;
        private long durationMillis = 0L;
        private final long startTimeMillis;
        private final boolean hasStartTime;
        private boolean hasTiming = false;
        private BlockEndNode endNode;
        private Row firstGraphChild;
        private Row nextGraphSibling;
        private Row firstTreeChild;
        private Row nextTreeSibling;
        private int treeDepth = -1;

        private Row(FlowNode node) {
            this.node = node;
            TimingAction act = (TimingAction)node.getPersistentAction(TimingAction.class);
            if (act != null) {
                this.startTimeMillis = act.getStartTime();
                this.hasStartTime = true;
                if (node.isActive()) {
                    this.durationMillis = System.currentTimeMillis() - this.startTimeMillis;
                    this.hasTiming = true;
                }
            } else {
                this.startTimeMillis = 0L;
                this.hasStartTime = false;
            }
        }

        public FlowNode getNode() {
            return this.node;
        }

        public int getTreeDepth() {
            return this.treeDepth;
        }

        public String getDisplayName() {
            if (this.node instanceof StepNode && this.node instanceof AtomNode) {
                return this.node.getDisplayFunctionName();
            }
            if (this.node instanceof StepNode && this.node instanceof BlockStartNode) {
                if (this.node.getPersistentAction(BodyInvocationAction.class) != null) {
                    LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
                    scanner.setup(this.node);
                    for (FlowNode start : scanner) {
                        if (!(start instanceof StepNode) || !(start instanceof BlockStartNode) || start.getPersistentAction(BodyInvocationAction.class) != null) continue;
                        String base = start.getDisplayFunctionName() + " block";
                        LabelAction a = (LabelAction)this.node.getPersistentAction(LabelAction.class);
                        return a != null ? base + " (" + a.getDisplayName() + ")" : base;
                    }
                } else {
                    return this.node.getDisplayFunctionName();
                }
            }
            return this.node.getDisplayFunctionName();
        }

        public boolean isHasStartTime() {
            return this.hasStartTime;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getDurationMillis() {
            return this.durationMillis;
        }

        private Row getNextGraphSibling() {
            return this.nextGraphSibling;
        }

        private Row getNextTreeSibling() {
            return this.nextTreeSibling;
        }

        public String getDurationString() {
            if (!this.hasTiming) {
                return "no timing";
            }
            if (this.durationMillis == 0L) {
                return "<1 ms";
            }
            return Util.getTimeSpanString((long)this.durationMillis);
        }

        public boolean isStart() {
            return this.node instanceof BlockStartNode;
        }

        boolean isEnd() {
            return this.node instanceof BlockEndNode;
        }

        public boolean isExecuted() {
            return NotExecutedNodeAction.isExecuted((FlowNode)this.node);
        }

        void addGraphChild(Row r) {
            if (this.firstGraphChild == null) {
                this.firstGraphChild = r;
            } else {
                this.firstGraphChild.addGraphSibling(r);
            }
        }

        void addGraphSibling(Row r) {
            Row s = this.findLastSibling(this, Row::getNextGraphSibling);
            s.nextGraphSibling = r;
            if (s.hasStartTime && r.hasStartTime) {
                s.durationMillis = r.startTimeMillis - s.startTimeMillis;
                s.hasTiming = true;
            }
        }

        void addTreeChild(Row r) {
            if (r.isEnd()) {
                return;
            }
            if (this.firstTreeChild == null) {
                this.firstTreeChild = r;
            } else {
                this.firstTreeChild.addTreeSibling(r);
            }
        }

        void addTreeSibling(Row r) {
            if (r.isEnd()) {
                return;
            }
            Row s = this.findLastSibling(this, Row::getNextTreeSibling);
            s.nextTreeSibling = r;
            if (s.hasStartTime && r.hasStartTime) {
                s.durationMillis = r.startTimeMillis - s.startTimeMillis;
                s.hasTiming = true;
            }
        }

        private Row findLastSibling(Row r, Function<Row, Row> siblingGetter) {
            Row s = r;
            IdentityHashMap<Row, Boolean> visited = new IdentityHashMap<Row, Boolean>(Collections.singletonMap(s, true));
            while (siblingGetter.apply(s) != null) {
                Row nextS = siblingGetter.apply(s);
                if (visited.put(nextS, true) != null) {
                    throw new IllegalStateException("Saw " + String.valueOf(nextS.node) + " twice when finding siblings of " + String.valueOf(r.node));
                }
                s = nextS;
            }
            return s;
        }
    }
}

