/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.scm.RunWithSCM;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;

public final class RunWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String externalizableId;
    private final boolean currentBuild;

    public RunWrapper(Run<?, ?> build, boolean currentBuild) {
        this.externalizableId = build.getExternalizableId();
        this.currentBuild = currentBuild;
    }

    @CheckForNull
    public Run<?, ?> getRawBuild() {
        return Run.fromExternalizableId((String)this.externalizableId);
    }

    @NonNull
    private Run<?, ?> build() throws AbortException {
        Run<?, ?> r = this.getRawBuild();
        if (r == null) {
            throw new AbortException("No build record " + this.externalizableId + " could be located.");
        }
        return r;
    }

    @Whitelisted
    public void setResult(String result) throws AbortException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the result property on the current build");
        }
        this.build().setResult(Result.fromString((String)result));
    }

    @Whitelisted
    public void setDescription(String d) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the description property on the current build");
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            this.build().setDescription(d);
        }
    }

    @Whitelisted
    public void setDisplayName(String n) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the displayName property on the current build");
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            this.build().setDisplayName(n);
        }
    }

    @Whitelisted
    public void setKeepLog(boolean b) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the keepLog property on the current build");
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            this.build().keepLog(b);
        }
    }

    @Whitelisted
    public int getNumber() throws AbortException {
        return this.build().getNumber();
    }

    @Whitelisted
    public JSONArray getBuildCauses() throws IOException, ClassNotFoundException {
        JSONArray result = new JSONArray();
        for (Cause cause : this.build().getCauses()) {
            StringWriter w = new StringWriter();
            CauseAction causeAction = new CauseAction(cause);
            DataWriter writer = Flavor.JSON.createDataWriter((Object)causeAction, (Writer)w);
            Model model = new ModelBuilder().get(CauseAction.class);
            model.writeTo((Object)causeAction, writer);
            result.add(JSONObject.fromObject((Object)w.toString()).getJSONArray("causes").get(0));
        }
        return result;
    }

    @Whitelisted
    public JSONArray getBuildCauses(String className) throws IOException {
        JSONArray result = new JSONArray();
        for (Cause cause : this.build().getCauses()) {
            if (!className.equals(cause.getClass().getName())) continue;
            StringWriter w = new StringWriter();
            CauseAction causeAction = new CauseAction(cause);
            DataWriter writer = Flavor.JSON.createDataWriter((Object)causeAction, (Writer)w);
            Model model = new ModelBuilder().get(CauseAction.class);
            model.writeTo((Object)causeAction, writer);
            result.add(JSONObject.fromObject((Object)w.toString()).getJSONArray("causes").get(0));
        }
        return result;
    }

    @Whitelisted
    @CheckForNull
    public String getResult() throws AbortException {
        Result result = this.build().getResult();
        return result != null ? result.toString() : null;
    }

    @Whitelisted
    @NonNull
    public String getCurrentResult() throws AbortException {
        Result result = this.build().getResult();
        return result != null ? result.toString() : Result.SUCCESS.toString();
    }

    @Whitelisted
    public boolean resultIsBetterOrEqualTo(String other) throws AbortException {
        Result result = this.build().getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        Result otherResult = Result.fromString((String)other);
        return result.isBetterOrEqualTo(otherResult);
    }

    @Whitelisted
    public boolean resultIsWorseOrEqualTo(String other) throws AbortException {
        Result result = this.build().getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        Result otherResult = Result.fromString((String)other);
        return result.isWorseOrEqualTo(otherResult);
    }

    @Whitelisted
    public long getTimeInMillis() throws AbortException {
        return this.build().getTimeInMillis();
    }

    @Whitelisted
    public long getStartTimeInMillis() throws AbortException {
        return this.build().getStartTimeInMillis();
    }

    @Whitelisted
    public long getDuration() throws AbortException {
        return this.build().getDuration() != 0L ? this.build().getDuration() : System.currentTimeMillis() - this.build().getStartTimeInMillis();
    }

    @Whitelisted
    public String getDurationString() throws AbortException {
        return this.build().getDurationString();
    }

    @Whitelisted
    public String getDescription() throws AbortException {
        return this.build().getDescription();
    }

    @Whitelisted
    public String getDisplayName() throws AbortException {
        return this.build().getDisplayName();
    }

    @Whitelisted
    public String getFullDisplayName() throws AbortException {
        return this.build().getFullDisplayName();
    }

    @Whitelisted
    public boolean isKeepLog() throws AbortException {
        return this.build().isKeepLog();
    }

    @Whitelisted
    public String getProjectName() throws AbortException {
        return this.build().getParent().getName();
    }

    @Whitelisted
    public String getFullProjectName() throws AbortException {
        return this.build().getParent().getFullName();
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousBuildInProgress() throws AbortException {
        Run previousBuild = this.build().getPreviousBuildInProgress();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousBuiltBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousBuiltBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousCompletedBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousCompletedBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousFailedBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousFailedBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousNotFailedBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousNotFailedBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousSuccessfulBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousSuccessfulBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getNextBuild() throws AbortException {
        Run nextBuild = this.build().getNextBuild();
        return nextBuild != null ? new RunWrapper(nextBuild, false) : null;
    }

    @Whitelisted
    public String getId() throws AbortException {
        return this.build().getId();
    }

    @Whitelisted
    public String getExternalizableId() {
        return this.externalizableId;
    }

    @Whitelisted
    @NonNull
    public Map<String, String> getBuildVariables() throws AbortException {
        Run<?, ?> build = this.build();
        if (build instanceof AbstractBuild) {
            HashMap buildVars = new HashMap();
            try {
                buildVars.putAll(build.getEnvironment(TaskListener.NULL));
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            buildVars.putAll(((AbstractBuild)build).getBuildVariables());
            return Collections.unmodifiableMap(buildVars);
        }
        EnvironmentAction.IncludingOverrides env = (EnvironmentAction.IncludingOverrides)build.getAction(EnvironmentAction.IncludingOverrides.class);
        if (env != null) {
            return env.getOverriddenEnvironment();
        }
        return Collections.emptyMap();
    }

    @Whitelisted
    @NonNull
    public List<RunWrapper> getUpstreamBuilds() throws AbortException {
        ArrayList<RunWrapper> upstreams = new ArrayList<RunWrapper>();
        Run<?, ?> build = this.build();
        for (Cause c : build.getCauses()) {
            if (!(c instanceof Cause.UpstreamCause)) continue;
            upstreams.addAll(this.upstreamCauseToRunWrappers((Cause.UpstreamCause)c));
        }
        return upstreams;
    }

    @NonNull
    private List<RunWrapper> upstreamCauseToRunWrappers(@NonNull Cause.UpstreamCause cause) {
        ArrayList<RunWrapper> upstreams = new ArrayList<RunWrapper>();
        Run r = cause.getUpstreamRun();
        if (r != null) {
            upstreams.add(new RunWrapper(r, false));
            for (Cause c : cause.getUpstreamCauses()) {
                if (!(c instanceof Cause.UpstreamCause)) continue;
                upstreams.addAll(this.upstreamCauseToRunWrappers((Cause.UpstreamCause)c));
            }
        }
        return upstreams;
    }

    @Whitelisted
    @NonNull
    public String getAbsoluteUrl() throws AbortException {
        return this.build().getAbsoluteUrl();
    }

    @Whitelisted
    public List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() throws Exception {
        Run<?, ?> build = this.build();
        if (build instanceof RunWithSCM) {
            return ((RunWithSCM)build).getChangeSets();
        }
        try {
            return (List)build.getClass().getMethod("getChangeSets", new Class[0]).invoke(build, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            return Collections.emptyList();
        }
    }
}

