/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles.serialization;

import hudson.ExtensionList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryCapsule;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryOwner;

public class RiverWriter
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(RiverWriter.class.getName());
    private final File file;
    private final FlowExecutionOwner owner;
    private final FileChannel channel;
    private final Marshaller marshaller;
    private boolean pickling;
    List<Pickle> pickles = new ArrayList<Pickle>();
    static final long HEADER = 7330745437582215633L;
    static final short VERSION = 1;
    private static final int EPHEMERALS_BACKPTR = 10;
    private static final ByteBuffer HEADER_BUFFER = (ByteBuffer)((Buffer)ByteBuffer.allocate(14).putLong(7330745437582215633L).putShort((short)1).putInt(0).asReadOnlyBuffer()).flip();

    @Deprecated
    public RiverWriter(File f, FlowExecutionOwner _owner) throws IOException {
        this(f, _owner, RiverWriter.pickleFactories());
    }

    private static Collection<? extends PickleFactory> pickleFactories() {
        ExtensionList pickleFactories = PickleFactory.all();
        if (pickleFactories.isEmpty()) {
            throw new IllegalStateException("JENKINS-26137: Jenkins is shutting down");
        }
        return pickleFactories;
    }

    public RiverWriter(File f, FlowExecutionOwner _owner, final Collection<? extends PickleFactory> pickleFactories) throws IOException {
        this.file = f;
        this.owner = _owner;
        this.channel = FileChannel.open(this.file.toPath(), StandardOpenOption.WRITE);
        this.channel.write(HEADER_BUFFER.duplicate());
        LOGGER.fine(() -> "Starting to save " + String.valueOf(this.file));
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setObjectResolver(new ObjectResolver(){

            public Object readResolve(Object o) {
                throw new IllegalStateException();
            }

            public Object writeReplace(Object o) {
                if (o == RiverWriter.this.owner) {
                    return new DryOwner();
                }
                if (RiverWriter.this.pickling) {
                    for (PickleFactory f : pickleFactories) {
                        Pickle v = f.writeReplace(o);
                        if (v == null) continue;
                        RiverWriter.this.pickles.add(v);
                        return new DryCapsule(RiverWriter.this.pickles.size() - 1);
                    }
                }
                return o;
            }
        });
        this.marshaller = new RiverMarshallerFactory().createMarshaller(config);
        this.marshaller.start((ByteOutput)new FileChannelOutput(this.channel));
        this.pickling = true;
    }

    public void writeObject(Object o) throws IOException {
        try {
            GroovySandbox.runInSandbox(() -> {
                this.marshaller.writeObject(o);
                return null;
            }, (Whitelist)Whitelist.all());
        }
        catch (IOException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new AssertionError((Object)x);
        }
        LOGGER.fine(() -> "Wrote main body to " + String.valueOf(this.file));
    }

    @Deprecated
    public ObjectOutput getObjectOutput() {
        return this.marshaller;
    }

    @Override
    public void close() throws IOException {
        int ephemeralsOffset;
        try {
            this.marshaller.finish();
            ephemeralsOffset = (int)this.channel.position();
            this.pickling = false;
            this.marshaller.start((ByteOutput)new FileChannelOutput(this.channel));
            this.marshaller.writeObject(this.pickles);
            this.marshaller.finish();
            this.channel.position(10L);
            ByteBuffer ephemeralsPtrBuffer = ByteBuffer.allocate(4).putInt(ephemeralsOffset);
            ephemeralsPtrBuffer.flip();
            this.channel.write(ephemeralsPtrBuffer);
            this.channel.force(true);
        }
        finally {
            this.channel.close();
        }
        LOGGER.fine(() -> "Closed " + String.valueOf(this.file) + "; pickle offset @" + ephemeralsOffset);
    }

    private static class FileChannelOutput
    implements ByteOutput {
        private final FileChannel channel;
        private final byte[] singleton = new byte[1];

        private FileChannelOutput(FileChannel channel) {
            this.channel = channel;
        }

        public void write(int b) throws IOException {
            this.singleton[0] = (byte)b;
            this.channel.write(ByteBuffer.wrap(this.singleton));
        }

        public void write(byte[] bytes) throws IOException {
            this.channel.write(ByteBuffer.wrap(bytes));
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.channel.write(ByteBuffer.wrap(bytes, off, len));
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }
    }
}

