/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles.serialization;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.jboss.marshalling.ObjectResolver;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryCapsule;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PickleResolver
implements ObjectResolver {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non-final for modification from script console")
    public static long RESOLUTION_TIMEOUT_SECONDS = SystemProperties.getLong((String)(String.valueOf(PickleResolver.class) + ".RESOLUTION_TIMEOUT_SECONDS"), (Long)TimeUnit.HOURS.toSeconds(1L));
    private final List<? extends Pickle> pickles;
    private List<Object> values;
    private final FlowExecutionOwner owner;

    @Deprecated
    public PickleResolver(List<? extends Pickle> pickles) {
        this(pickles, FlowExecutionOwner.dummyOwner());
    }

    public PickleResolver(List<? extends Pickle> pickles, FlowExecutionOwner owner) {
        this.pickles = pickles;
        this.owner = owner;
    }

    public Object get(int id) {
        return this.values.get(id);
    }

    @Deprecated
    public ListenableFuture<PickleResolver> rehydrate() {
        return this.rehydrate(new ArrayList());
    }

    public ListenableFuture<PickleResolver> rehydrate(Collection<ListenableFuture<?>> pickleFutures) {
        if (this.pickles.isEmpty()) {
            return Futures.immediateFuture((Object)this);
        }
        ArrayList<ListenableFuture> members = new ArrayList<ListenableFuture>();
        for (Pickle pickle : this.pickles) {
            ListenableFuture future;
            try {
                future = Futures.withTimeout((ListenableFuture)pickle.rehydrate(this.owner), (long)RESOLUTION_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS, (ScheduledExecutorService)Timer.get());
            }
            catch (RuntimeException x) {
                future = Futures.immediateFailedFuture((Throwable)x);
            }
            pickleFutures.add(future);
            members.add(Futures.transform((ListenableFuture)future, (Function)new Function<Object, Object>(){

                public Object apply(Object input) {
                    return input;
                }
            }, (Executor)MoreExecutors.directExecutor()));
        }
        ListenableFuture all = Futures.allAsList(members);
        return Futures.transform((ListenableFuture)all, (Function)new Function<List<Object>, PickleResolver>(){

            public PickleResolver apply(List<Object> input) {
                PickleResolver.this.values = input;
                return PickleResolver.this;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public Object readResolve(Object o) {
        if (o instanceof DryCapsule) {
            DryCapsule cap = (DryCapsule)o;
            return this.get(cap.id);
        }
        return o;
    }

    public Object writeReplace(Object original) {
        throw new IllegalStateException();
    }
}

