/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class PauseAction
extends InvisibleAction
implements PersistentAction {
    private static final Logger LOGGER = Logger.getLogger(PauseAction.class.getName());
    private String cause;
    private long startTime = System.currentTimeMillis();
    private long endTime;

    public PauseAction(String cause) {
        this.cause = cause;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isPaused() {
        return this.endTime == 0L;
    }

    public long getPauseDuration() {
        if (this.isPaused()) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    @CheckForNull
    public static PauseAction getCurrentPause(@NonNull FlowNode node) {
        List<PauseAction> pauseActions = PauseAction.getPauseActions(node);
        if (!pauseActions.isEmpty()) {
            return pauseActions.get(pauseActions.size() - 1);
        }
        return null;
    }

    public static void endCurrentPause(@NonNull FlowNode node) throws IOException {
        PauseAction currentPause = PauseAction.getCurrentPause(node);
        if (currentPause != null) {
            currentPause.setEndTime(System.currentTimeMillis());
            node.save();
        } else {
            LOGGER.log(Level.FINE, "\u2018endCurrentPause\u2019 was called for a FlowNode (\u2018{0}\u2019) that does not have an active pause. \u2018endCurrentPause\u2019 may have already been called.", node.getDisplayName());
        }
    }

    public static boolean isPaused(@NonNull FlowNode node) {
        PauseAction currentPause = PauseAction.getCurrentPause(node);
        if (currentPause != null) {
            return currentPause.isPaused();
        }
        return false;
    }

    @NonNull
    public static List<PauseAction> getPauseActions(@NonNull FlowNode node) {
        ArrayList<PauseAction> pauseActions = new ArrayList<PauseAction>();
        List actions = node.getActions();
        for (Action action : actions) {
            if (!(action instanceof PauseAction)) continue;
            pauseActions.add((PauseAction)action);
        }
        return pauseActions;
    }

    public static long getPauseDuration(@NonNull FlowNode node) {
        List<PauseAction> pauseActions = PauseAction.getPauseActions(node);
        long pauseDuration = 0L;
        for (PauseAction pauseAction : pauseActions) {
            pauseDuration += pauseAction.getPauseDuration();
        }
        return pauseDuration;
    }
}

