/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.actions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.CloseProofOutputStream;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleLogFilter;
import hudson.model.Action;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.PersistentAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.framework.io.ByteBuffer;

@Deprecated
public class LogActionImpl
extends LogAction
implements FlowNodeAction,
PersistentAction {
    private static final Logger LOGGER = Logger.getLogger(LogActionImpl.class.getName());
    private transient FlowNode parent;
    private volatile transient File log;
    private String charset;

    static boolean isOld(FlowExecutionOwner owner) {
        try {
            Queue.Executable exec = owner.getExecutable();
            return exec instanceof Run && !Util.isOverridden(Run.class, (Class)exec.getClass(), (String)"getLogFile", (Class[])new Class[0]);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            return false;
        }
    }

    @Deprecated
    @NonNull
    public static TaskListener stream(@NonNull FlowNode node, @CheckForNull ConsoleLogFilter filter) throws IOException, InterruptedException {
        return LogActionImpl.stream(node, TaskListenerDecorator.fromConsoleLogFilter((ConsoleLogFilter)filter));
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION_EXCEPTION_EDGE"})
    @NonNull
    public static TaskListener stream(@NonNull FlowNode node, @CheckForNull TaskListenerDecorator decorator) throws IOException, InterruptedException {
        LogActionImpl la = (LogActionImpl)node.getAction(LogActionImpl.class);
        if (la == null) {
            la = new LogActionImpl(node);
            node.addAction((Action)la);
        }
        OutputStream os = new FileOutputStream(la.getLogFile(), true);
        FlowExecutionOwner owner = node.getExecution().getOwner();
        if (!LogActionImpl.isOld(owner)) {
            os = new TeeOutputStream(os, (OutputStream)new CloseProofOutputStream((OutputStream)owner.getListener().getLogger()));
        }
        if (decorator != null) {
            os = decorator.decorate(os);
        }
        return new StreamTaskListener(os, la.getCharset());
    }

    private LogActionImpl(FlowNode parent) throws IOException {
        this.parent = parent;
    }

    @Restricted(value={DoNotUse.class})
    public FlowNode getParent() {
        return this.parent;
    }

    public AnnotatedLargeText<? extends FlowNode> getLogText() {
        try {
            this.getLogFile();
            if (!this.log.exists()) {
                return new AnnotatedLargeText(new ByteBuffer(), this.getCharset(), !this.parent.isActive(), (Object)this.parent);
            }
            return new AnnotatedLargeText(this.log, this.getCharset(), !this.parent.isActive(), (Object)this.parent);
        }
        catch (IOException e) {
            ByteBuffer buf = new ByteBuffer();
            PrintStream ps = new PrintStream((OutputStream)buf, false, StandardCharsets.UTF_8);
            ps.println("Failed to find log file for id=" + this.parent.getId());
            e.printStackTrace(ps);
            ps.close();
            return new AnnotatedLargeText(buf, StandardCharsets.UTF_8, true, (Object)this.parent);
        }
    }

    private File getLogFile() throws IOException {
        if (this.log == null) {
            this.log = new File(this.parent.getExecution().getOwner().getRootDir(), this.parent.getId() + ".log");
        }
        return this.log;
    }

    @Restricted(value={DoNotUse.class})
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Deprecated and unused code, only exists for compatibility with old builds")
    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        AnnotatedLargeText<? extends FlowNode> l = this.getLogText();
        if (l != null) {
            l.writeHtmlTo(offset, out.asWriter());
        }
    }

    public void onLoad(FlowNode parent) {
        this.parent = parent;
    }

    private Charset getCharset() {
        if (this.charset == null) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(this.charset);
    }

    public String toString() {
        return "LogActionImpl[" + String.valueOf(this.log) + "]";
    }
}

